/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RevokeGrantRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RevokeGrantRequest> {
    private final String keyId;
    private final String grantId;

    private RevokeGrantRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
    }

    public String keyId() {
        return this.keyId;
    }

    public String grantId() {
        return this.grantId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeGrantRequest)) {
            return false;
        }
        RevokeGrantRequest other = (RevokeGrantRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.grantId(), other.grantId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.grantId() != null) {
            sb.append("GrantId: ").append(this.grantId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.of(clazz.cast(this.grantId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeGrantRequest model) {
            this.keyId(model.keyId);
            this.grantId(model.grantId);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        public RevokeGrantRequest build() {
            return new RevokeGrantRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevokeGrantRequest> {
        public Builder keyId(String var1);

        public Builder grantId(String var1);
    }
}

