/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.services.kms.model.GrantOperation;
import software.amazon.awssdk.services.kms.model.GrantOperationListCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGrantRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateGrantRequest> {
    private final String keyId;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final List<String> operations;
    private final GrantConstraints constraints;
    private final List<String> grantTokens;
    private final String name;

    private CreateGrantRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
        this.grantTokens = builder.grantTokens;
        this.name = builder.name;
    }

    public String keyId() {
        return this.keyId;
    }

    public String granteePrincipal() {
        return this.granteePrincipal;
    }

    public String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public List<GrantOperation> operations() {
        return TypeConverter.convert(this.operations, GrantOperation::fromValue);
    }

    public List<String> operationsStrings() {
        return this.operations;
    }

    public GrantConstraints constraints() {
        return this.constraints;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.granteePrincipal() == null ? 0 : this.granteePrincipal().hashCode());
        hashCode = 31 * hashCode + (this.retiringPrincipal() == null ? 0 : this.retiringPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.operationsStrings() == null ? 0 : this.operationsStrings().hashCode());
        hashCode = 31 * hashCode + (this.constraints() == null ? 0 : this.constraints().hashCode());
        hashCode = 31 * hashCode + (this.grantTokens() == null ? 0 : this.grantTokens().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.granteePrincipal() == null ^ this.granteePrincipal() == null) {
            return false;
        }
        if (other.granteePrincipal() != null && !other.granteePrincipal().equals(this.granteePrincipal())) {
            return false;
        }
        if (other.retiringPrincipal() == null ^ this.retiringPrincipal() == null) {
            return false;
        }
        if (other.retiringPrincipal() != null && !other.retiringPrincipal().equals(this.retiringPrincipal())) {
            return false;
        }
        if (other.operationsStrings() == null ^ this.operationsStrings() == null) {
            return false;
        }
        if (other.operationsStrings() != null && !other.operationsStrings().equals(this.operationsStrings())) {
            return false;
        }
        if (other.constraints() == null ^ this.constraints() == null) {
            return false;
        }
        if (other.constraints() != null && !other.constraints().equals(this.constraints())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        if (other.grantTokens() != null && !other.grantTokens().equals(this.grantTokens())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.granteePrincipal() != null) {
            sb.append("GranteePrincipal: ").append(this.granteePrincipal()).append(",");
        }
        if (this.retiringPrincipal() != null) {
            sb.append("RetiringPrincipal: ").append(this.retiringPrincipal()).append(",");
        }
        if (this.operationsStrings() != null) {
            sb.append("Operations: ").append(this.operationsStrings()).append(",");
        }
        if (this.constraints() != null) {
            sb.append("Constraints: ").append(this.constraints()).append(",");
        }
        if (this.grantTokens() != null) {
            sb.append("GrantTokens: ").append(this.grantTokens()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "GranteePrincipal": {
                return Optional.of(clazz.cast(this.granteePrincipal()));
            }
            case "RetiringPrincipal": {
                return Optional.of(clazz.cast(this.retiringPrincipal()));
            }
            case "Operations": {
                return Optional.of(clazz.cast(this.operationsStrings()));
            }
            case "Constraints": {
                return Optional.of(clazz.cast(this.constraints()));
            }
            case "GrantTokens": {
                return Optional.of(clazz.cast(this.grantTokens()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String granteePrincipal;
        private String retiringPrincipal;
        private List<String> operations;
        private GrantConstraints constraints;
        private List<String> grantTokens;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantRequest model) {
            this.keyId(model.keyId);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.operations(model.operations);
            this.constraints(model.constraints);
            this.grantTokens(model.grantTokens);
            this.name(model.name);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        public final Collection<String> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        public final GrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(GrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public CreateGrantRequest build() {
            return new CreateGrantRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateGrantRequest> {
        public Builder keyId(String var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder operations(Collection<String> var1);

        public Builder operations(String ... var1);

        public Builder constraints(GrantConstraints var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder name(String var1);
    }
}

