/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateRandomRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GenerateRandomRequest> {
    private final Integer numberOfBytes;

    private GenerateRandomRequest(BuilderImpl builder) {
        this.numberOfBytes = builder.numberOfBytes;
    }

    public Integer numberOfBytes() {
        return this.numberOfBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.numberOfBytes() == null ? 0 : this.numberOfBytes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomRequest)) {
            return false;
        }
        GenerateRandomRequest other = (GenerateRandomRequest)((Object)obj);
        if (other.numberOfBytes() == null ^ this.numberOfBytes() == null) {
            return false;
        }
        return other.numberOfBytes() == null || other.numberOfBytes().equals(this.numberOfBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.numberOfBytes() != null) {
            sb.append("NumberOfBytes: ").append(this.numberOfBytes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer numberOfBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomRequest model) {
            this.setNumberOfBytes(model.numberOfBytes);
        }

        public final Integer getNumberOfBytes() {
            return this.numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        public GenerateRandomRequest build() {
            return new GenerateRandomRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenerateRandomRequest> {
        public Builder numberOfBytes(Integer var1);
    }
}

