/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.kms.model.AliasListCopier;
import software.amazon.awssdk.services.kms.model.AliasListEntry;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAliasesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAliasesResponse> {
    private final List<AliasListEntry> aliases;
    private final String nextMarker;
    private final Boolean truncated;

    private ListAliasesResponse(BuilderImpl builder) {
        this.aliases = builder.aliases;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public List<AliasListEntry> aliases() {
        return this.aliases;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aliases() == null ? 0 : this.aliases().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.truncated() == null ? 0 : this.truncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResponse)) {
            return false;
        }
        ListAliasesResponse other = (ListAliasesResponse)((Object)obj);
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        if (other.aliases() != null && !other.aliases().equals(this.aliases())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.truncated() == null ^ this.truncated() == null) {
            return false;
        }
        return other.truncated() == null || other.truncated().equals(this.truncated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aliases() != null) {
            sb.append("Aliases: ").append(this.aliases()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.truncated() != null) {
            sb.append("Truncated: ").append(this.truncated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AliasListEntry> aliases;
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesResponse model) {
            this.setAliases(model.aliases);
            this.setNextMarker(model.nextMarker);
            this.setTruncated(model.truncated);
        }

        public final Collection<AliasListEntry> getAliases() {
            return this.aliases;
        }

        @Override
        public final Builder aliases(Collection<AliasListEntry> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(AliasListEntry ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final void setAliases(Collection<AliasListEntry> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        public ListAliasesResponse build() {
            return new ListAliasesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAliasesResponse> {
        public Builder aliases(Collection<AliasListEntry> var1);

        public Builder aliases(AliasListEntry ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

