/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EncryptRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EncryptRequest> {
    private final String keyId;
    private final ByteBuffer plaintext;
    private final Map<String, String> encryptionContext;
    private final List<String> grantTokens;

    private EncryptRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
        this.encryptionContext = builder.encryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    public String keyId() {
        return this.keyId;
    }

    public ByteBuffer plaintext() {
        return this.plaintext == null ? null : this.plaintext.asReadOnlyBuffer();
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.plaintext() == null ? 0 : this.plaintext().hashCode());
        hashCode = 31 * hashCode + (this.encryptionContext() == null ? 0 : this.encryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.grantTokens() == null ? 0 : this.grantTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptRequest)) {
            return false;
        }
        EncryptRequest other = (EncryptRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        if (other.plaintext() != null && !other.plaintext().equals(this.plaintext())) {
            return false;
        }
        if (other.encryptionContext() == null ^ this.encryptionContext() == null) {
            return false;
        }
        if (other.encryptionContext() != null && !other.encryptionContext().equals(this.encryptionContext())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        return other.grantTokens() == null || other.grantTokens().equals(this.grantTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.plaintext() != null) {
            sb.append("Plaintext: ").append(this.plaintext()).append(",");
        }
        if (this.encryptionContext() != null) {
            sb.append("EncryptionContext: ").append(this.encryptionContext()).append(",");
        }
        if (this.grantTokens() != null) {
            sb.append("GrantTokens: ").append(this.grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private ByteBuffer plaintext;
        private Map<String, String> encryptionContext;
        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptRequest model) {
            this.setKeyId(model.keyId);
            this.setPlaintext(model.plaintext);
            this.setEncryptionContext(model.encryptionContext);
            this.setGrantTokens(model.grantTokens);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
        }

        public final Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public EncryptRequest build() {
            return new EncryptRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptRequest> {
        public Builder keyId(String var1);

        public Builder plaintext(ByteBuffer var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);
    }
}

