/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.model.EncryptResponse;

public class EncryptResponseUnmarshaller
implements Unmarshaller<EncryptResponse, JsonUnmarshallerContext> {
    private static EncryptResponseUnmarshaller INSTANCE;

    public EncryptResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        EncryptResponse.Builder encryptResponseBuilder = EncryptResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return (EncryptResponse)((Object)encryptResponseBuilder.build());
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CiphertextBlob", targetDepth)) {
                    context.nextToken();
                    encryptResponseBuilder.ciphertextBlob((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    encryptResponseBuilder.keyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EncryptResponse)((Object)encryptResponseBuilder.build());
    }

    public static EncryptResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EncryptResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

