/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.kms.model.PolicyNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListKeyPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListKeyPoliciesResponse> {
    private final List<String> policyNames;
    private final String nextMarker;
    private final Boolean truncated;

    private ListKeyPoliciesResponse(BuilderImpl builder) {
        this.policyNames = builder.policyNames;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.truncated() == null ? 0 : this.truncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyPoliciesResponse)) {
            return false;
        }
        ListKeyPoliciesResponse other = (ListKeyPoliciesResponse)((Object)obj);
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        if (other.policyNames() != null && !other.policyNames().equals(this.policyNames())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.truncated() == null ^ this.truncated() == null) {
            return false;
        }
        return other.truncated() == null || other.truncated().equals(this.truncated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.truncated() != null) {
            sb.append("Truncated: ").append(this.truncated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> policyNames;
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyPoliciesResponse model) {
            this.setPolicyNames(model.policyNames);
            this.setNextMarker(model.nextMarker);
            this.setTruncated(model.truncated);
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
        }

        @SafeVarargs
        public final void setPolicyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        public ListKeyPoliciesResponse build() {
            return new ListKeyPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListKeyPoliciesResponse> {
        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

