/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportKeyMaterialRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportKeyMaterialRequest> {
    private final String keyId;
    private final ByteBuffer importToken;
    private final ByteBuffer encryptedKeyMaterial;
    private final Instant validTo;
    private final String expirationModel;

    private ImportKeyMaterialRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.importToken = builder.importToken;
        this.encryptedKeyMaterial = builder.encryptedKeyMaterial;
        this.validTo = builder.validTo;
        this.expirationModel = builder.expirationModel;
    }

    public String keyId() {
        return this.keyId;
    }

    public ByteBuffer importToken() {
        return this.importToken == null ? null : this.importToken.asReadOnlyBuffer();
    }

    public ByteBuffer encryptedKeyMaterial() {
        return this.encryptedKeyMaterial == null ? null : this.encryptedKeyMaterial.asReadOnlyBuffer();
    }

    public Instant validTo() {
        return this.validTo;
    }

    public String expirationModel() {
        return this.expirationModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.importToken() == null ? 0 : this.importToken().hashCode());
        hashCode = 31 * hashCode + (this.encryptedKeyMaterial() == null ? 0 : this.encryptedKeyMaterial().hashCode());
        hashCode = 31 * hashCode + (this.validTo() == null ? 0 : this.validTo().hashCode());
        hashCode = 31 * hashCode + (this.expirationModel() == null ? 0 : this.expirationModel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyMaterialRequest)) {
            return false;
        }
        ImportKeyMaterialRequest other = (ImportKeyMaterialRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.importToken() == null ^ this.importToken() == null) {
            return false;
        }
        if (other.importToken() != null && !other.importToken().equals(this.importToken())) {
            return false;
        }
        if (other.encryptedKeyMaterial() == null ^ this.encryptedKeyMaterial() == null) {
            return false;
        }
        if (other.encryptedKeyMaterial() != null && !other.encryptedKeyMaterial().equals(this.encryptedKeyMaterial())) {
            return false;
        }
        if (other.validTo() == null ^ this.validTo() == null) {
            return false;
        }
        if (other.validTo() != null && !other.validTo().equals(this.validTo())) {
            return false;
        }
        if (other.expirationModel() == null ^ this.expirationModel() == null) {
            return false;
        }
        return other.expirationModel() == null || other.expirationModel().equals(this.expirationModel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.importToken() != null) {
            sb.append("ImportToken: ").append(this.importToken()).append(",");
        }
        if (this.encryptedKeyMaterial() != null) {
            sb.append("EncryptedKeyMaterial: ").append(this.encryptedKeyMaterial()).append(",");
        }
        if (this.validTo() != null) {
            sb.append("ValidTo: ").append(this.validTo()).append(",");
        }
        if (this.expirationModel() != null) {
            sb.append("ExpirationModel: ").append(this.expirationModel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private ByteBuffer importToken;
        private ByteBuffer encryptedKeyMaterial;
        private Instant validTo;
        private String expirationModel;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyMaterialRequest model) {
            this.setKeyId(model.keyId);
            this.setImportToken(model.importToken);
            this.setEncryptedKeyMaterial(model.encryptedKeyMaterial);
            this.setValidTo(model.validTo);
            this.setExpirationModel(model.expirationModel);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getImportToken() {
            return this.importToken;
        }

        @Override
        public final Builder importToken(ByteBuffer importToken) {
            this.importToken = StandardMemberCopier.copy((ByteBuffer)importToken);
            return this;
        }

        public final void setImportToken(ByteBuffer importToken) {
            this.importToken = StandardMemberCopier.copy((ByteBuffer)importToken);
        }

        public final ByteBuffer getEncryptedKeyMaterial() {
            return this.encryptedKeyMaterial;
        }

        @Override
        public final Builder encryptedKeyMaterial(ByteBuffer encryptedKeyMaterial) {
            this.encryptedKeyMaterial = StandardMemberCopier.copy((ByteBuffer)encryptedKeyMaterial);
            return this;
        }

        public final void setEncryptedKeyMaterial(ByteBuffer encryptedKeyMaterial) {
            this.encryptedKeyMaterial = StandardMemberCopier.copy((ByteBuffer)encryptedKeyMaterial);
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getExpirationModel() {
            return this.expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        public final void setExpirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
        }

        public ImportKeyMaterialRequest build() {
            return new ImportKeyMaterialRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportKeyMaterialRequest> {
        public Builder keyId(String var1);

        public Builder importToken(ByteBuffer var1);

        public Builder encryptedKeyMaterial(ByteBuffer var1);

        public Builder validTo(Instant var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);
    }
}

