/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeKeyRequest> {
    private final String keyId;
    private final List<String> grantTokens;

    private DescribeKeyRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.grantTokens = builder.grantTokens;
    }

    public String keyId() {
        return this.keyId;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.grantTokens() == null ? 0 : this.grantTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyRequest)) {
            return false;
        }
        DescribeKeyRequest other = (DescribeKeyRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        return other.grantTokens() == null || other.grantTokens().equals(this.grantTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.grantTokens() != null) {
            sb.append("GrantTokens: ").append(this.grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyRequest model) {
            this.setKeyId(model.keyId);
            this.setGrantTokens(model.grantTokens);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @SafeVarargs
        public final void setGrantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
        }

        public DescribeKeyRequest build() {
            return new DescribeKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeKeyRequest> {
        public Builder keyId(String var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);
    }
}

