/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.services.kms.model.Tag;
import software.amazon.awssdk.services.kms.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateKeyRequest> {
    private final String policy;
    private final String description;
    private final String keyUsage;
    private final String origin;
    private final Boolean bypassPolicyLockoutSafetyCheck;
    private final List<Tag> tags;

    private CreateKeyRequest(BuilderImpl builder) {
        this.policy = builder.policy;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.origin = builder.origin;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
        this.tags = builder.tags;
    }

    public String policy() {
        return this.policy;
    }

    public String description() {
        return this.description;
    }

    public String keyUsage() {
        return this.keyUsage;
    }

    public String origin() {
        return this.origin;
    }

    public Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policy() == null ? 0 : this.policy().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.keyUsage() == null ? 0 : this.keyUsage().hashCode());
        hashCode = 31 * hashCode + (this.origin() == null ? 0 : this.origin().hashCode());
        hashCode = 31 * hashCode + (this.bypassPolicyLockoutSafetyCheck() == null ? 0 : this.bypassPolicyLockoutSafetyCheck().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyRequest)) {
            return false;
        }
        CreateKeyRequest other = (CreateKeyRequest)((Object)obj);
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.keyUsage() == null ^ this.keyUsage() == null) {
            return false;
        }
        if (other.keyUsage() != null && !other.keyUsage().equals(this.keyUsage())) {
            return false;
        }
        if (other.origin() == null ^ this.origin() == null) {
            return false;
        }
        if (other.origin() != null && !other.origin().equals(this.origin())) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() == null ^ this.bypassPolicyLockoutSafetyCheck() == null) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() != null && !other.bypassPolicyLockoutSafetyCheck().equals(this.bypassPolicyLockoutSafetyCheck())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policy() != null) {
            sb.append("Policy: ").append(this.policy()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.keyUsage() != null) {
            sb.append("KeyUsage: ").append(this.keyUsage()).append(",");
        }
        if (this.origin() != null) {
            sb.append("Origin: ").append(this.origin()).append(",");
        }
        if (this.bypassPolicyLockoutSafetyCheck() != null) {
            sb.append("BypassPolicyLockoutSafetyCheck: ").append(this.bypassPolicyLockoutSafetyCheck()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String policy;
        private String description;
        private String keyUsage;
        private String origin;
        private Boolean bypassPolicyLockoutSafetyCheck;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyRequest model) {
            this.setPolicy(model.policy);
            this.setDescription(model.description);
            this.setKeyUsage(model.keyUsage);
            this.setOrigin(model.origin);
            this.setBypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
            this.setTags(model.tags);
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final void setKeyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
        }

        public final String getOrigin() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final void setOrigin(OriginType origin) {
            this.origin(origin.toString());
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public CreateKeyRequest build() {
            return new CreateKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateKeyRequest> {
        public Builder policy(String var1);

        public Builder description(String var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

