/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.kms.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * ImportKeyMaterialRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ImportKeyMaterialRequestModelMarshaller {

    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<java.nio.ByteBuffer> IMPORTTOKEN_BINDING = MarshallingInfo
            .builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportToken")
            .build();
    private static final MarshallingInfo<java.nio.ByteBuffer> ENCRYPTEDKEYMATERIAL_BINDING = MarshallingInfo
            .builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EncryptedKeyMaterial").build();
    private static final MarshallingInfo<java.time.Instant> VALIDTO_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidTo").build();
    private static final MarshallingInfo<String> EXPIRATIONMODEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationModel").build();

    private static final ImportKeyMaterialRequestModelMarshaller instance = new ImportKeyMaterialRequestModelMarshaller();

    public static ImportKeyMaterialRequestModelMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ImportKeyMaterialRequest importKeyMaterialRequest, ProtocolMarshaller protocolMarshaller) {

        if (importKeyMaterialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(importKeyMaterialRequest.keyId(), KEYID_BINDING);

            protocolMarshaller.marshall(importKeyMaterialRequest.importToken(), IMPORTTOKEN_BINDING);

            protocolMarshaller.marshall(importKeyMaterialRequest.encryptedKeyMaterial(), ENCRYPTEDKEYMATERIAL_BINDING);

            protocolMarshaller.marshall(importKeyMaterialRequest.validTo(), VALIDTO_BINDING);

            protocolMarshaller.marshall(importKeyMaterialRequest.expirationModel(), EXPIRATIONMODEL_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
