/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;

import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.kms.model.*;
import software.amazon.awssdk.services.kms.transform.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * GenerateDataKeyWithoutPlaintextRequest Marshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class GenerateDataKeyWithoutPlaintextRequestMarshaller implements
        Marshaller<Request<GenerateDataKeyWithoutPlaintextRequest>, GenerateDataKeyWithoutPlaintextRequest> {

    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON)
            .requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true)
            .operationIdentifier("TrentService.GenerateDataKeyWithoutPlaintext").serviceName("KMSClient").build();

    private final software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory protocolFactory;

    public GenerateDataKeyWithoutPlaintextRequestMarshaller(
            software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GenerateDataKeyWithoutPlaintextRequest> marshall(
            GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {

        if (generateDataKeyWithoutPlaintextRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            final ProtocolRequestMarshaller<GenerateDataKeyWithoutPlaintextRequest> protocolMarshaller = protocolFactory
                    .createProtocolMarshaller(SDK_OPERATION_BINDING, generateDataKeyWithoutPlaintextRequest);

            protocolMarshaller.startMarshalling();
            GenerateDataKeyWithoutPlaintextRequestModelMarshaller.getInstance().marshall(generateDataKeyWithoutPlaintextRequest,
                    protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
