/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.TagMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag
 * values can be empty (null) strings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Tag implements StructuredPojo, ToCopyableBuilder<Tag.Builder, Tag> {
    private final String tagKey;

    private final String tagValue;

    private Tag(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
    }

    /**
     * <p>
     * The key of the tag.
     * </p>
     * 
     * @return The key of the tag.
     */
    public String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The value of the tag.
     * </p>
     * 
     * @return The value of the tag.
     */
    public String tagValue() {
        return tagValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tagKey() == null) ? 0 : tagKey().hashCode());
        hashCode = 31 * hashCode + ((tagValue() == null) ? 0 : tagValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag) obj;
        if (other.tagKey() == null ^ this.tagKey() == null) {
            return false;
        }
        if (other.tagKey() != null && !other.tagKey().equals(this.tagKey())) {
            return false;
        }
        if (other.tagValue() == null ^ this.tagValue() == null) {
            return false;
        }
        if (other.tagValue() != null && !other.tagValue().equals(this.tagValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tagKey() != null) {
            sb.append("TagKey: ").append(tagKey()).append(",");
        }
        if (tagValue() != null) {
            sb.append("TagValue: ").append(tagValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Tag> {
        /**
         * <p>
         * The key of the tag.
         * </p>
         * 
         * @param tagKey
         *        The key of the tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The value of the tag.
         * </p>
         * 
         * @param tagValue
         *        The value of the tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);
    }

    private static final class BuilderImpl implements Builder {
        private String tagKey;

        private String tagValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            setTagKey(model.tagKey);
            setTagValue(model.tagValue);
        }

        public final String getTagKey() {
            return tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public Tag build() {
            return new Tag(this);
        }
    }
}
