/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleKeyDeletionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ScheduleKeyDeletionRequest.Builder, ScheduleKeyDeletionRequest> {
    private final String keyId;

    private final Integer pendingWindowInDays;

    private ScheduleKeyDeletionRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.pendingWindowInDays = builder.pendingWindowInDays;
    }

    /**
     * <p>
     * The unique identifier for the customer master key (CMK) to delete.
     * </p>
     * <p>
     * To specify this value, use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain the unique key ID and key ARN for a given CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * </p>
     * 
     * @return The unique identifier for the customer master key (CMK) to delete.</p>
     *         <p>
     *         To specify this value, use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To obtain the unique key ID and key ARN for a given CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the customer
     * master key (CMK).
     * </p>
     * <p>
     * This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a
     * value, it defaults to 30.
     * </p>
     * 
     * @return The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the
     *         customer master key (CMK).</p>
     *         <p>
     *         This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not
     *         include a value, it defaults to 30.
     */
    public Integer pendingWindowInDays() {
        return pendingWindowInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((pendingWindowInDays() == null) ? 0 : pendingWindowInDays().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleKeyDeletionRequest)) {
            return false;
        }
        ScheduleKeyDeletionRequest other = (ScheduleKeyDeletionRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.pendingWindowInDays() == null ^ this.pendingWindowInDays() == null) {
            return false;
        }
        if (other.pendingWindowInDays() != null && !other.pendingWindowInDays().equals(this.pendingWindowInDays())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (pendingWindowInDays() != null) {
            sb.append("PendingWindowInDays: ").append(pendingWindowInDays()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleKeyDeletionRequest> {
        /**
         * <p>
         * The unique identifier for the customer master key (CMK) to delete.
         * </p>
         * <p>
         * To specify this value, use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * </li>
         * </ul>
         * <p>
         * To obtain the unique key ID and key ARN for a given CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
         * </p>
         * 
         * @param keyId
         *        The unique identifier for the customer master key (CMK) to delete.</p>
         *        <p>
         *        To specify this value, use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To obtain the unique key ID and key ARN for a given CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the customer
         * master key (CMK).
         * </p>
         * <p>
         * This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include
         * a value, it defaults to 30.
         * </p>
         * 
         * @param pendingWindowInDays
         *        The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the
         *        customer master key (CMK).</p>
         *        <p>
         *        This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not
         *        include a value, it defaults to 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingWindowInDays(Integer pendingWindowInDays);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private Integer pendingWindowInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleKeyDeletionRequest model) {
            setKeyId(model.keyId);
            setPendingWindowInDays(model.pendingWindowInDays);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Integer getPendingWindowInDays() {
            return pendingWindowInDays;
        }

        @Override
        public final Builder pendingWindowInDays(Integer pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
            return this;
        }

        public final void setPendingWindowInDays(Integer pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
        }

        @Override
        public ScheduleKeyDeletionRequest build() {
            return new ScheduleKeyDeletionRequest(this);
        }
    }
}
