/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ReEncryptResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ReEncryptResponse.Builder, ReEncryptResponse> {
    private final ByteBuffer ciphertextBlob;

    private final String sourceKeyId;

    private final String keyId;

    private ReEncryptResponse(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceKeyId = builder.sourceKeyId;
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * The reencrypted data.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The reencrypted data.
     */
    public ByteBuffer ciphertextBlob() {
        return ciphertextBlob == null ? null : ciphertextBlob.asReadOnlyBuffer();
    }

    /**
     * <p>
     * Unique identifier of the CMK used to originally encrypt the data.
     * </p>
     * 
     * @return Unique identifier of the CMK used to originally encrypt the data.
     */
    public String sourceKeyId() {
        return sourceKeyId;
    }

    /**
     * <p>
     * Unique identifier of the CMK used to reencrypt the data.
     * </p>
     * 
     * @return Unique identifier of the CMK used to reencrypt the data.
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ciphertextBlob() == null) ? 0 : ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + ((sourceKeyId() == null) ? 0 : sourceKeyId().hashCode());
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptResponse)) {
            return false;
        }
        ReEncryptResponse other = (ReEncryptResponse) obj;
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.sourceKeyId() == null ^ this.sourceKeyId() == null) {
            return false;
        }
        if (other.sourceKeyId() != null && !other.sourceKeyId().equals(this.sourceKeyId())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(ciphertextBlob()).append(",");
        }
        if (sourceKeyId() != null) {
            sb.append("SourceKeyId: ").append(sourceKeyId()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReEncryptResponse> {
        /**
         * <p>
         * The reencrypted data.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param ciphertextBlob
         *        The reencrypted data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertextBlob(ByteBuffer ciphertextBlob);

        /**
         * <p>
         * Unique identifier of the CMK used to originally encrypt the data.
         * </p>
         * 
         * @param sourceKeyId
         *        Unique identifier of the CMK used to originally encrypt the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKeyId(String sourceKeyId);

        /**
         * <p>
         * Unique identifier of the CMK used to reencrypt the data.
         * </p>
         * 
         * @param keyId
         *        Unique identifier of the CMK used to reencrypt the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer ciphertextBlob;

        private String sourceKeyId;

        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptResponse model) {
            setCiphertextBlob(model.ciphertextBlob);
            setSourceKeyId(model.sourceKeyId);
            setKeyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
        }

        public final String getSourceKeyId() {
            return sourceKeyId;
        }

        @Override
        public final Builder sourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
            return this;
        }

        public final void setSourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public ReEncryptResponse build() {
            return new ReEncryptResponse(this);
        }
    }
}
