/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListRetirableGrantsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListRetirableGrantsRequest.Builder, ListRetirableGrantsRequest> {
    private final Integer limit;

    private final String marker;

    private final String retiringPrincipal;

    private ListRetirableGrantsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.retiringPrincipal = builder.retiringPrincipal;
    }

    /**
     * <p>
     * Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not
     * return more than the specified number of items, but it might return fewer.
     * </p>
     * <p>
     * This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a
     * value, it defaults to 50.
     * </p>
     * 
     * @return Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS
     *         does not return more than the specified number of items, but it might return fewer.</p>
     *         <p>
     *         This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not
     *         include a value, it defaults to 50.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the
     * value of <code>NextMarker</code> from the truncated response you just received.
     * </p>
     * 
     * @return Use this parameter in a subsequent request after you receive a response with truncated results. Set it to
     *         the value of <code>NextMarker</code> from the truncated response you just received.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The retiring principal for which to list grants.
     * </p>
     * <p>
     * To specify the retiring principal, use the <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users, and assumed
     * role users. For examples of the ARN syntax for specifying a principal, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
     * Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The retiring principal for which to list grants.</p>
     *         <p>
     *         To specify the retiring principal, use the <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated
     *         users, and assumed role users. For examples of the ARN syntax for specifying a principal, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
     *         Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services
     *         General Reference</i>.
     */
    public String retiringPrincipal() {
        return retiringPrincipal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((retiringPrincipal() == null) ? 0 : retiringPrincipal().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetirableGrantsRequest)) {
            return false;
        }
        ListRetirableGrantsRequest other = (ListRetirableGrantsRequest) obj;
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.retiringPrincipal() == null ^ this.retiringPrincipal() == null) {
            return false;
        }
        if (other.retiringPrincipal() != null && !other.retiringPrincipal().equals(this.retiringPrincipal())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (retiringPrincipal() != null) {
            sb.append("RetiringPrincipal: ").append(retiringPrincipal()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListRetirableGrantsRequest> {
        /**
         * <p>
         * Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does
         * not return more than the specified number of items, but it might return fewer.
         * </p>
         * <p>
         * This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not
         * include a value, it defaults to 50.
         * </p>
         * 
         * @param limit
         *        Use this parameter to specify the maximum number of items to return. When this value is present, AWS
         *        KMS does not return more than the specified number of items, but it might return fewer.</p>
         *        <p>
         *        This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not
         *        include a value, it defaults to 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the
         * value of <code>NextMarker</code> from the truncated response you just received.
         * </p>
         * 
         * @param marker
         *        Use this parameter in a subsequent request after you receive a response with truncated results. Set it
         *        to the value of <code>NextMarker</code> from the truncated response you just received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The retiring principal for which to list grants.
         * </p>
         * <p>
         * To specify the retiring principal, use the <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users,
         * and assumed role users. For examples of the ARN syntax for specifying a principal, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity
         * and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General
         * Reference</i>.
         * </p>
         * 
         * @param retiringPrincipal
         *        The retiring principal for which to list grants.</p>
         *        <p>
         *        To specify the retiring principal, use the <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated
         *        users, and assumed role users. For examples of the ARN syntax for specifying a principal, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS
         *        Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services
         *        General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retiringPrincipal(String retiringPrincipal);
    }

    private static final class BuilderImpl implements Builder {
        private Integer limit;

        private String marker;

        private String retiringPrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetirableGrantsRequest model) {
            setLimit(model.limit);
            setMarker(model.marker);
            setRetiringPrincipal(model.retiringPrincipal);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getRetiringPrincipal() {
            return retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        @Override
        public ListRetirableGrantsRequest build() {
            return new ListRetirableGrantsRequest(this);
        }
    }
}
