/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.KeyListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about each entry in the key list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyListEntry implements StructuredPojo, ToCopyableBuilder<KeyListEntry.Builder, KeyListEntry> {
    private final String keyId;

    private final String keyArn;

    private KeyListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyArn = builder.keyArn;
    }

    /**
     * <p>
     * Unique identifier of the key.
     * </p>
     * 
     * @return Unique identifier of the key.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * ARN of the key.
     * </p>
     * 
     * @return ARN of the key.
     */
    public String keyArn() {
        return keyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((keyArn() == null) ? 0 : keyArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyListEntry)) {
            return false;
        }
        KeyListEntry other = (KeyListEntry) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.keyArn() == null ^ this.keyArn() == null) {
            return false;
        }
        if (other.keyArn() != null && !other.keyArn().equals(this.keyArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (keyArn() != null) {
            sb.append("KeyArn: ").append(keyArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyListEntry> {
        /**
         * <p>
         * Unique identifier of the key.
         * </p>
         * 
         * @param keyId
         *        Unique identifier of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * ARN of the key.
         * </p>
         * 
         * @param keyArn
         *        ARN of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private String keyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyListEntry model) {
            setKeyId(model.keyId);
            setKeyArn(model.keyArn);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getKeyArn() {
            return keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public KeyListEntry build() {
            return new KeyListEntry(this);
        }
    }
}
