/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request was rejected because the state of the specified resource is not valid for this request.
 * </p>
 * <p>
 * For more information about how key state affects the use of a CMK, see <a
 * href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a Customer
 * Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KMSInvalidStateException extends KMSException implements
        ToCopyableBuilder<KMSInvalidStateException.Builder, KMSInvalidStateException> {
    private KMSInvalidStateException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, KMSInvalidStateException> {
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSInvalidStateException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public KMSInvalidStateException build() {
            return new KMSInvalidStateException(this);
        }
    }
}
