/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParametersForImportResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetParametersForImportResponse.Builder, GetParametersForImportResponse> {
    private final String keyId;

    private final ByteBuffer importToken;

    private final ByteBuffer publicKey;

    private final Instant parametersValidTo;

    private GetParametersForImportResponse(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.importToken = builder.importToken;
        this.publicKey = builder.publicKey;
        this.parametersValidTo = builder.parametersValidTo;
    }

    /**
     * <p>
     * The identifier of the CMK to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same CMK specified
     * in the <code>GetParametersForImport</code> request.
     * </p>
     * 
     * @return The identifier of the CMK to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same CMK
     *         specified in the <code>GetParametersForImport</code> request.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The import token to send in a subsequent <a>ImportKeyMaterial</a> request.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The import token to send in a subsequent <a>ImportKeyMaterial</a> request.
     */
    public ByteBuffer importToken() {
        return importToken == null ? null : importToken.asReadOnlyBuffer();
    }

    /**
     * <p>
     * The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
     */
    public ByteBuffer publicKey() {
        return publicKey == null ? null : publicKey.asReadOnlyBuffer();
    }

    /**
     * <p>
     * The time at which the import token and public key are no longer valid. After this time, you cannot use them to
     * make an <a>ImportKeyMaterial</a> request and you must send another <code>GetParametersForImport</code> request to
     * retrieve new ones.
     * </p>
     * 
     * @return The time at which the import token and public key are no longer valid. After this time, you cannot use
     *         them to make an <a>ImportKeyMaterial</a> request and you must send another
     *         <code>GetParametersForImport</code> request to retrieve new ones.
     */
    public Instant parametersValidTo() {
        return parametersValidTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((importToken() == null) ? 0 : importToken().hashCode());
        hashCode = 31 * hashCode + ((publicKey() == null) ? 0 : publicKey().hashCode());
        hashCode = 31 * hashCode + ((parametersValidTo() == null) ? 0 : parametersValidTo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportResponse)) {
            return false;
        }
        GetParametersForImportResponse other = (GetParametersForImportResponse) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.importToken() == null ^ this.importToken() == null) {
            return false;
        }
        if (other.importToken() != null && !other.importToken().equals(this.importToken())) {
            return false;
        }
        if (other.publicKey() == null ^ this.publicKey() == null) {
            return false;
        }
        if (other.publicKey() != null && !other.publicKey().equals(this.publicKey())) {
            return false;
        }
        if (other.parametersValidTo() == null ^ this.parametersValidTo() == null) {
            return false;
        }
        if (other.parametersValidTo() != null && !other.parametersValidTo().equals(this.parametersValidTo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (importToken() != null) {
            sb.append("ImportToken: ").append(importToken()).append(",");
        }
        if (publicKey() != null) {
            sb.append("PublicKey: ").append(publicKey()).append(",");
        }
        if (parametersValidTo() != null) {
            sb.append("ParametersValidTo: ").append(parametersValidTo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetParametersForImportResponse> {
        /**
         * <p>
         * The identifier of the CMK to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same CMK
         * specified in the <code>GetParametersForImport</code> request.
         * </p>
         * 
         * @param keyId
         *        The identifier of the CMK to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same
         *        CMK specified in the <code>GetParametersForImport</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The import token to send in a subsequent <a>ImportKeyMaterial</a> request.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param importToken
         *        The import token to send in a subsequent <a>ImportKeyMaterial</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importToken(ByteBuffer importToken);

        /**
         * <p>
         * The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param publicKey
         *        The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(ByteBuffer publicKey);

        /**
         * <p>
         * The time at which the import token and public key are no longer valid. After this time, you cannot use them
         * to make an <a>ImportKeyMaterial</a> request and you must send another <code>GetParametersForImport</code>
         * request to retrieve new ones.
         * </p>
         * 
         * @param parametersValidTo
         *        The time at which the import token and public key are no longer valid. After this time, you cannot use
         *        them to make an <a>ImportKeyMaterial</a> request and you must send another
         *        <code>GetParametersForImport</code> request to retrieve new ones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersValidTo(Instant parametersValidTo);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private ByteBuffer importToken;

        private ByteBuffer publicKey;

        private Instant parametersValidTo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportResponse model) {
            setKeyId(model.keyId);
            setImportToken(model.importToken);
            setPublicKey(model.publicKey);
            setParametersValidTo(model.parametersValidTo);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getImportToken() {
            return importToken;
        }

        @Override
        public final Builder importToken(ByteBuffer importToken) {
            this.importToken = StandardMemberCopier.copy(importToken);
            return this;
        }

        public final void setImportToken(ByteBuffer importToken) {
            this.importToken = StandardMemberCopier.copy(importToken);
        }

        public final ByteBuffer getPublicKey() {
            return publicKey;
        }

        @Override
        public final Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = StandardMemberCopier.copy(publicKey);
            return this;
        }

        public final void setPublicKey(ByteBuffer publicKey) {
            this.publicKey = StandardMemberCopier.copy(publicKey);
        }

        public final Instant getParametersValidTo() {
            return parametersValidTo;
        }

        @Override
        public final Builder parametersValidTo(Instant parametersValidTo) {
            this.parametersValidTo = parametersValidTo;
            return this;
        }

        public final void setParametersValidTo(Instant parametersValidTo) {
            this.parametersValidTo = parametersValidTo;
        }

        @Override
        public GetParametersForImportResponse build() {
            return new GetParametersForImportResponse(this);
        }
    }
}
