/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GenerateRandomResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GenerateRandomResponse.Builder, GenerateRandomResponse> {
    private final ByteBuffer plaintext;

    private GenerateRandomResponse(BuilderImpl builder) {
        this.plaintext = builder.plaintext;
    }

    /**
     * <p>
     * The random byte string.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The random byte string.
     */
    public ByteBuffer plaintext() {
        return plaintext == null ? null : plaintext.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((plaintext() == null) ? 0 : plaintext().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomResponse)) {
            return false;
        }
        GenerateRandomResponse other = (GenerateRandomResponse) obj;
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        if (other.plaintext() != null && !other.plaintext().equals(this.plaintext())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (plaintext() != null) {
            sb.append("Plaintext: ").append(plaintext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GenerateRandomResponse> {
        /**
         * <p>
         * The random byte string.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param plaintext
         *        The random byte string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plaintext(ByteBuffer plaintext);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomResponse model) {
            setPlaintext(model.plaintext);
        }

        public final ByteBuffer getPlaintext() {
            return plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
        }

        @Override
        public GenerateRandomResponse build() {
            return new GenerateRandomResponse(this);
        }
    }
}
