/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GenerateDataKeyWithoutPlaintextRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GenerateDataKeyWithoutPlaintextRequest.Builder, GenerateDataKeyWithoutPlaintextRequest> {
    private final String keyId;

    private final Map<String, String> encryptionContext;

    private final String keySpec;

    private final Integer numberOfBytes;

    private final List<String> grantTokens;

    private GenerateDataKeyWithoutPlaintextRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.encryptionContext = builder.encryptionContext;
        this.keySpec = builder.keySpec;
        this.numberOfBytes = builder.numberOfBytes;
        this.grantTokens = builder.grantTokens;
    }

    /**
     * <p>
     * The identifier of the CMK under which to generate and encrypt the data encryption key.
     * </p>
     * <p>
     * A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK, or the alias name or ARN of
     * an alias that refers to the CMK. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * CMK ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name: <code>alias/ExampleAlias</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the CMK under which to generate and encrypt the data encryption key.</p>
     *         <p>
     *         A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK, or the alias name
     *         or ARN of an alias that refers to the CMK. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CMK ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name: <code>alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * A set of key-value pairs that represents additional authenticated data.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of key-value pairs that represents additional authenticated data.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption
     *         Context</a> in the <i>AWS Key Management Service Developer Guide</i>.
     */
    public Map<String, String> encryptionContext() {
        return encryptionContext;
    }

    /**
     * <p>
     * The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or
     * <code>AES_256</code> to generate a 256-bit symmetric key.
     * </p>
     * 
     * @return The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or
     *         <code>AES_256</code> to generate a 256-bit symmetric key.
     * @see DataKeySpec
     */
    public String keySpec() {
        return keySpec;
    }

    /**
     * <p>
     * The length of the data encryption key in bytes. For example, use the value 64 to generate a 512-bit data key (64
     * bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use the
     * <code>KeySpec</code> field instead of this one.
     * </p>
     * 
     * @return The length of the data encryption key in bytes. For example, use the value 64 to generate a 512-bit data
     *         key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend
     *         that you use the <code>KeySpec</code> field instead of this one.
     */
    public Integer numberOfBytes() {
        return numberOfBytes;
    }

    /**
     * <p>
     * A list of grant tokens.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of grant tokens.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in
     *         the <i>AWS Key Management Service Developer Guide</i>.
     */
    public List<String> grantTokens() {
        return grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((encryptionContext() == null) ? 0 : encryptionContext().hashCode());
        hashCode = 31 * hashCode + ((keySpec() == null) ? 0 : keySpec().hashCode());
        hashCode = 31 * hashCode + ((numberOfBytes() == null) ? 0 : numberOfBytes().hashCode());
        hashCode = 31 * hashCode + ((grantTokens() == null) ? 0 : grantTokens().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyWithoutPlaintextRequest)) {
            return false;
        }
        GenerateDataKeyWithoutPlaintextRequest other = (GenerateDataKeyWithoutPlaintextRequest) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.encryptionContext() == null ^ this.encryptionContext() == null) {
            return false;
        }
        if (other.encryptionContext() != null && !other.encryptionContext().equals(this.encryptionContext())) {
            return false;
        }
        if (other.keySpec() == null ^ this.keySpec() == null) {
            return false;
        }
        if (other.keySpec() != null && !other.keySpec().equals(this.keySpec())) {
            return false;
        }
        if (other.numberOfBytes() == null ^ this.numberOfBytes() == null) {
            return false;
        }
        if (other.numberOfBytes() != null && !other.numberOfBytes().equals(this.numberOfBytes())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        if (other.grantTokens() != null && !other.grantTokens().equals(this.grantTokens())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (encryptionContext() != null) {
            sb.append("EncryptionContext: ").append(encryptionContext()).append(",");
        }
        if (keySpec() != null) {
            sb.append("KeySpec: ").append(keySpec()).append(",");
        }
        if (numberOfBytes() != null) {
            sb.append("NumberOfBytes: ").append(numberOfBytes()).append(",");
        }
        if (grantTokens() != null) {
            sb.append("GrantTokens: ").append(grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GenerateDataKeyWithoutPlaintextRequest> {
        /**
         * <p>
         * The identifier of the CMK under which to generate and encrypt the data encryption key.
         * </p>
         * <p>
         * A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK, or the alias name or
         * ARN of an alias that refers to the CMK. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * CMK ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name: <code>alias/ExampleAlias</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        The identifier of the CMK under which to generate and encrypt the data encryption key.</p>
         *        <p>
         *        A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK, or the alias
         *        name or ARN of an alias that refers to the CMK. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CMK ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name: <code>alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * A set of key-value pairs that represents additional authenticated data.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in
         * the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param encryptionContext
         *        A set of key-value pairs that represents additional authenticated data.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption
         *        Context</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionContext(Map<String, String> encryptionContext);

        /**
         * <p>
         * The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or
         * <code>AES_256</code> to generate a 256-bit symmetric key.
         * </p>
         * 
         * @param keySpec
         *        The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key,
         *        or <code>AES_256</code> to generate a 256-bit symmetric key.
         * @see DataKeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataKeySpec
         */
        Builder keySpec(String keySpec);

        /**
         * <p>
         * The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or
         * <code>AES_256</code> to generate a 256-bit symmetric key.
         * </p>
         * 
         * @param keySpec
         *        The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key,
         *        or <code>AES_256</code> to generate a 256-bit symmetric key.
         * @see DataKeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataKeySpec
         */
        Builder keySpec(DataKeySpec keySpec);

        /**
         * <p>
         * The length of the data encryption key in bytes. For example, use the value 64 to generate a 512-bit data key
         * (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you
         * use the <code>KeySpec</code> field instead of this one.
         * </p>
         * 
         * @param numberOfBytes
         *        The length of the data encryption key in bytes. For example, use the value 64 to generate a 512-bit
         *        data key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we
         *        recommend that you use the <code>KeySpec</code> field instead of this one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBytes(Integer numberOfBytes);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(Collection<String> grantTokens);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(String... grantTokens);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private Map<String, String> encryptionContext;

        private String keySpec;

        private Integer numberOfBytes;

        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyWithoutPlaintextRequest model) {
            setKeyId(model.keyId);
            setEncryptionContext(model.encryptionContext);
            setKeySpec(model.keySpec);
            setNumberOfBytes(model.numberOfBytes);
            setGrantTokens(model.grantTokens);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Map<String, String> getEncryptionContext() {
            return encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final String getKeySpec() {
            return keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(DataKeySpec keySpec) {
            this.keySpec(keySpec.toString());
            return this;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        public final void setKeySpec(DataKeySpec keySpec) {
            this.keySpec(keySpec.toString());
        }

        public final Integer getNumberOfBytes() {
            return numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        public final Collection<String> getGrantTokens() {
            return grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @SafeVarargs
        public final void setGrantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
        }

        @Override
        public GenerateDataKeyWithoutPlaintextRequest build() {
            return new GenerateDataKeyWithoutPlaintextRequest(this);
        }
    }
}
