/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GenerateDataKeyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GenerateDataKeyResponse.Builder, GenerateDataKeyResponse> {
    private final ByteBuffer ciphertextBlob;

    private final ByteBuffer plaintext;

    private final String keyId;

    private GenerateDataKeyResponse(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.plaintext = builder.plaintext;
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * The encrypted data encryption key.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The encrypted data encryption key.
     */
    public ByteBuffer ciphertextBlob() {
        return ciphertextBlob == null ? null : ciphertextBlob.asReadOnlyBuffer();
    }

    /**
     * <p>
     * The data encryption key. Use this data key for local encryption and decryption, then remove it from memory as
     * soon as possible.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The data encryption key. Use this data key for local encryption and decryption, then remove it from
     *         memory as soon as possible.
     */
    public ByteBuffer plaintext() {
        return plaintext == null ? null : plaintext.asReadOnlyBuffer();
    }

    /**
     * <p>
     * The identifier of the CMK under which the data encryption key was generated and encrypted.
     * </p>
     * 
     * @return The identifier of the CMK under which the data encryption key was generated and encrypted.
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ciphertextBlob() == null) ? 0 : ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + ((plaintext() == null) ? 0 : plaintext().hashCode());
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyResponse)) {
            return false;
        }
        GenerateDataKeyResponse other = (GenerateDataKeyResponse) obj;
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        if (other.plaintext() != null && !other.plaintext().equals(this.plaintext())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(ciphertextBlob()).append(",");
        }
        if (plaintext() != null) {
            sb.append("Plaintext: ").append(plaintext()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GenerateDataKeyResponse> {
        /**
         * <p>
         * The encrypted data encryption key.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param ciphertextBlob
         *        The encrypted data encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertextBlob(ByteBuffer ciphertextBlob);

        /**
         * <p>
         * The data encryption key. Use this data key for local encryption and decryption, then remove it from memory as
         * soon as possible.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param plaintext
         *        The data encryption key. Use this data key for local encryption and decryption, then remove it from
         *        memory as soon as possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plaintext(ByteBuffer plaintext);

        /**
         * <p>
         * The identifier of the CMK under which the data encryption key was generated and encrypted.
         * </p>
         * 
         * @param keyId
         *        The identifier of the CMK under which the data encryption key was generated and encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer ciphertextBlob;

        private ByteBuffer plaintext;

        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyResponse model) {
            setCiphertextBlob(model.ciphertextBlob);
            setPlaintext(model.plaintext);
            setKeyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
        }

        public final ByteBuffer getPlaintext() {
            return plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public GenerateDataKeyResponse build() {
            return new GenerateDataKeyResponse(this);
        }
    }
}
