/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class EncryptResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<EncryptResponse.Builder, EncryptResponse> {
    private final ByteBuffer ciphertextBlob;

    private final String keyId;

    private EncryptResponse(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * The encrypted plaintext. If you are using the CLI, the value is Base64 encoded. Otherwise, it is not encoded.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The encrypted plaintext. If you are using the CLI, the value is Base64 encoded. Otherwise, it is not
     *         encoded.
     */
    public ByteBuffer ciphertextBlob() {
        return ciphertextBlob == null ? null : ciphertextBlob.asReadOnlyBuffer();
    }

    /**
     * <p>
     * The ID of the key used during encryption.
     * </p>
     * 
     * @return The ID of the key used during encryption.
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ciphertextBlob() == null) ? 0 : ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptResponse)) {
            return false;
        }
        EncryptResponse other = (EncryptResponse) obj;
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(ciphertextBlob()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, EncryptResponse> {
        /**
         * <p>
         * The encrypted plaintext. If you are using the CLI, the value is Base64 encoded. Otherwise, it is not encoded.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param ciphertextBlob
         *        The encrypted plaintext. If you are using the CLI, the value is Base64 encoded. Otherwise, it is not
         *        encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertextBlob(ByteBuffer ciphertextBlob);

        /**
         * <p>
         * The ID of the key used during encryption.
         * </p>
         * 
         * @param keyId
         *        The ID of the key used during encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer ciphertextBlob;

        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptResponse model) {
            setCiphertextBlob(model.ciphertextBlob);
            setKeyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public EncryptResponse build() {
            return new EncryptResponse(this);
        }
    }
}
