/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteAliasRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteAliasRequest.Builder, DeleteAliasRequest> {
    private final String aliasName;

    private DeleteAliasRequest(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
    }

    /**
     * <p>
     * The alias to be deleted. The name must start with the word "alias" followed by a forward slash (alias/). Aliases
     * that begin with "alias/AWS" are reserved.
     * </p>
     * 
     * @return The alias to be deleted. The name must start with the word "alias" followed by a forward slash (alias/).
     *         Aliases that begin with "alias/AWS" are reserved.
     */
    public String aliasName() {
        return aliasName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((aliasName() == null) ? 0 : aliasName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAliasRequest)) {
            return false;
        }
        DeleteAliasRequest other = (DeleteAliasRequest) obj;
        if (other.aliasName() == null ^ this.aliasName() == null) {
            return false;
        }
        if (other.aliasName() != null && !other.aliasName().equals(this.aliasName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (aliasName() != null) {
            sb.append("AliasName: ").append(aliasName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteAliasRequest> {
        /**
         * <p>
         * The alias to be deleted. The name must start with the word "alias" followed by a forward slash (alias/).
         * Aliases that begin with "alias/AWS" are reserved.
         * </p>
         * 
         * @param aliasName
         *        The alias to be deleted. The name must start with the word "alias" followed by a forward slash
         *        (alias/). Aliases that begin with "alias/AWS" are reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);
    }

    private static final class BuilderImpl implements Builder {
        private String aliasName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAliasRequest model) {
            setAliasName(model.aliasName);
        }

        public final String getAliasName() {
            return aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public DeleteAliasRequest build() {
            return new DeleteAliasRequest(this);
        }
    }
}
