/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DecryptResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DecryptResponse.Builder, DecryptResponse> {
    private final String keyId;

    private final ByteBuffer plaintext;

    private DecryptResponse(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
    }

    /**
     * <p>
     * ARN of the key used to perform the decryption. This value is returned if no errors are encountered during the
     * operation.
     * </p>
     * 
     * @return ARN of the key used to perform the decryption. This value is returned if no errors are encountered during
     *         the operation.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Decrypted plaintext data. This value may not be returned if the customer master key is not available or if you
     * didn't have permission to use it.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return Decrypted plaintext data. This value may not be returned if the customer master key is not available or
     *         if you didn't have permission to use it.
     */
    public ByteBuffer plaintext() {
        return plaintext == null ? null : plaintext.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((plaintext() == null) ? 0 : plaintext().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptResponse)) {
            return false;
        }
        DecryptResponse other = (DecryptResponse) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        if (other.plaintext() != null && !other.plaintext().equals(this.plaintext())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (plaintext() != null) {
            sb.append("Plaintext: ").append(plaintext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DecryptResponse> {
        /**
         * <p>
         * ARN of the key used to perform the decryption. This value is returned if no errors are encountered during the
         * operation.
         * </p>
         * 
         * @param keyId
         *        ARN of the key used to perform the decryption. This value is returned if no errors are encountered
         *        during the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Decrypted plaintext data. This value may not be returned if the customer master key is not available or if
         * you didn't have permission to use it.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param plaintext
         *        Decrypted plaintext data. This value may not be returned if the customer master key is not available
         *        or if you didn't have permission to use it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plaintext(ByteBuffer plaintext);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private ByteBuffer plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptResponse model) {
            setKeyId(model.keyId);
            setPlaintext(model.plaintext);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getPlaintext() {
            return plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
        }

        @Override
        public DecryptResponse build() {
            return new DecryptResponse(this);
        }
    }
}
