/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DecryptRequest extends AmazonWebServiceRequest implements ToCopyableBuilder<DecryptRequest.Builder, DecryptRequest> {
    private final ByteBuffer ciphertextBlob;

    private final Map<String, String> encryptionContext;

    private final List<String> grantTokens;

    private DecryptRequest(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.encryptionContext = builder.encryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    /**
     * <p>
     * Ciphertext to be decrypted. The blob includes metadata.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return Ciphertext to be decrypted. The blob includes metadata.
     */
    public ByteBuffer ciphertextBlob() {
        return ciphertextBlob == null ? null : ciphertextBlob.asReadOnlyBuffer();
    }

    /**
     * <p>
     * The encryption context. If this was specified in the <a>Encrypt</a> function, it must be specified here or the
     * decryption operation will fail. For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The encryption context. If this was specified in the <a>Encrypt</a> function, it must be specified here
     *         or the decryption operation will fail. For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption
     *         Context</a>.
     */
    public Map<String, String> encryptionContext() {
        return encryptionContext;
    }

    /**
     * <p>
     * A list of grant tokens.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of grant tokens.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in
     *         the <i>AWS Key Management Service Developer Guide</i>.
     */
    public List<String> grantTokens() {
        return grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ciphertextBlob() == null) ? 0 : ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + ((encryptionContext() == null) ? 0 : encryptionContext().hashCode());
        hashCode = 31 * hashCode + ((grantTokens() == null) ? 0 : grantTokens().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptRequest)) {
            return false;
        }
        DecryptRequest other = (DecryptRequest) obj;
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.encryptionContext() == null ^ this.encryptionContext() == null) {
            return false;
        }
        if (other.encryptionContext() != null && !other.encryptionContext().equals(this.encryptionContext())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        if (other.grantTokens() != null && !other.grantTokens().equals(this.grantTokens())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(ciphertextBlob()).append(",");
        }
        if (encryptionContext() != null) {
            sb.append("EncryptionContext: ").append(encryptionContext()).append(",");
        }
        if (grantTokens() != null) {
            sb.append("GrantTokens: ").append(grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DecryptRequest> {
        /**
         * <p>
         * Ciphertext to be decrypted. The blob includes metadata.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param ciphertextBlob
         *        Ciphertext to be decrypted. The blob includes metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertextBlob(ByteBuffer ciphertextBlob);

        /**
         * <p>
         * The encryption context. If this was specified in the <a>Encrypt</a> function, it must be specified here or
         * the decryption operation will fail. For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a>.
         * </p>
         * 
         * @param encryptionContext
         *        The encryption context. If this was specified in the <a>Encrypt</a> function, it must be specified
         *        here or the decryption operation will fail. For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption
         *        Context</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionContext(Map<String, String> encryptionContext);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(Collection<String> grantTokens);

        /**
         * <p>
         * A list of grant tokens.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantTokens
         *        A list of grant tokens.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTokens(String... grantTokens);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer ciphertextBlob;

        private Map<String, String> encryptionContext;

        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptRequest model) {
            setCiphertextBlob(model.ciphertextBlob);
            setEncryptionContext(model.encryptionContext);
            setGrantTokens(model.grantTokens);
        }

        public final ByteBuffer getCiphertextBlob() {
            return ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy(ciphertextBlob);
        }

        public final Map<String, String> getEncryptionContext() {
            return encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @SafeVarargs
        public final void setGrantTokens(String... grantTokens) {
            grantTokens(Arrays.asList(grantTokens));
        }

        @Override
        public DecryptRequest build() {
            return new DecryptRequest(this);
        }
    }
}
