/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateKeyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateKeyResponse.Builder, CreateKeyResponse> {
    private final KeyMetadata keyMetadata;

    private CreateKeyResponse(BuilderImpl builder) {
        this.keyMetadata = builder.keyMetadata;
    }

    /**
     * <p>
     * Metadata associated with the CMK.
     * </p>
     * 
     * @return Metadata associated with the CMK.
     */
    public KeyMetadata keyMetadata() {
        return keyMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyMetadata() == null) ? 0 : keyMetadata().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyResponse)) {
            return false;
        }
        CreateKeyResponse other = (CreateKeyResponse) obj;
        if (other.keyMetadata() == null ^ this.keyMetadata() == null) {
            return false;
        }
        if (other.keyMetadata() != null && !other.keyMetadata().equals(this.keyMetadata())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyMetadata() != null) {
            sb.append("KeyMetadata: ").append(keyMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateKeyResponse> {
        /**
         * <p>
         * Metadata associated with the CMK.
         * </p>
         * 
         * @param keyMetadata
         *        Metadata associated with the CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMetadata(KeyMetadata keyMetadata);
    }

    private static final class BuilderImpl implements Builder {
        private KeyMetadata keyMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyResponse model) {
            setKeyMetadata(model.keyMetadata);
        }

        public final KeyMetadata getKeyMetadata() {
            return keyMetadata;
        }

        @Override
        public final Builder keyMetadata(KeyMetadata keyMetadata) {
            this.keyMetadata = keyMetadata;
            return this;
        }

        public final void setKeyMetadata(KeyMetadata keyMetadata) {
            this.keyMetadata = keyMetadata;
        }

        @Override
        public CreateKeyResponse build() {
            return new CreateKeyResponse(this);
        }
    }
}
