/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateGrantResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateGrantResponse.Builder, CreateGrantResponse> {
    private final String grantToken;

    private final String grantId;

    private CreateGrantResponse(BuilderImpl builder) {
        this.grantToken = builder.grantToken;
        this.grantId = builder.grantId;
    }

    /**
     * <p>
     * The grant token.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The grant token.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in
     *         the <i>AWS Key Management Service Developer Guide</i>.
     */
    public String grantToken() {
        return grantToken;
    }

    /**
     * <p>
     * The unique identifier for the grant.
     * </p>
     * <p>
     * You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.
     * </p>
     * 
     * @return The unique identifier for the grant.</p>
     *         <p>
     *         You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.
     */
    public String grantId() {
        return grantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((grantToken() == null) ? 0 : grantToken().hashCode());
        hashCode = 31 * hashCode + ((grantId() == null) ? 0 : grantId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantResponse)) {
            return false;
        }
        CreateGrantResponse other = (CreateGrantResponse) obj;
        if (other.grantToken() == null ^ this.grantToken() == null) {
            return false;
        }
        if (other.grantToken() != null && !other.grantToken().equals(this.grantToken())) {
            return false;
        }
        if (other.grantId() == null ^ this.grantId() == null) {
            return false;
        }
        if (other.grantId() != null && !other.grantId().equals(this.grantId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (grantToken() != null) {
            sb.append("GrantToken: ").append(grantToken()).append(",");
        }
        if (grantId() != null) {
            sb.append("GrantId: ").append(grantId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateGrantResponse> {
        /**
         * <p>
         * The grant token.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
         * <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantToken
         *        The grant token.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
         *        in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantToken(String grantToken);

        /**
         * <p>
         * The unique identifier for the grant.
         * </p>
         * <p>
         * You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.
         * </p>
         * 
         * @param grantId
         *        The unique identifier for the grant.</p>
         *        <p>
         *        You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantId(String grantId);
    }

    private static final class BuilderImpl implements Builder {
        private String grantToken;

        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantResponse model) {
            setGrantToken(model.grantToken);
            setGrantId(model.grantId);
        }

        public final String getGrantToken() {
            return grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getGrantId() {
            return grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public CreateGrantResponse build() {
            return new CreateGrantResponse(this);
        }
    }
}
