/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.AliasListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AliasListEntry implements StructuredPojo, ToCopyableBuilder<AliasListEntry.Builder, AliasListEntry> {
    private final String aliasName;

    private final String aliasArn;

    private final String targetKeyId;

    private AliasListEntry(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.aliasArn = builder.aliasArn;
        this.targetKeyId = builder.targetKeyId;
    }

    /**
     * <p>
     * String that contains the alias.
     * </p>
     * 
     * @return String that contains the alias.
     */
    public String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * String that contains the key ARN.
     * </p>
     * 
     * @return String that contains the key ARN.
     */
    public String aliasArn() {
        return aliasArn;
    }

    /**
     * <p>
     * String that contains the key identifier referred to by the alias.
     * </p>
     * 
     * @return String that contains the key identifier referred to by the alias.
     */
    public String targetKeyId() {
        return targetKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((aliasName() == null) ? 0 : aliasName().hashCode());
        hashCode = 31 * hashCode + ((aliasArn() == null) ? 0 : aliasArn().hashCode());
        hashCode = 31 * hashCode + ((targetKeyId() == null) ? 0 : targetKeyId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasListEntry)) {
            return false;
        }
        AliasListEntry other = (AliasListEntry) obj;
        if (other.aliasName() == null ^ this.aliasName() == null) {
            return false;
        }
        if (other.aliasName() != null && !other.aliasName().equals(this.aliasName())) {
            return false;
        }
        if (other.aliasArn() == null ^ this.aliasArn() == null) {
            return false;
        }
        if (other.aliasArn() != null && !other.aliasArn().equals(this.aliasArn())) {
            return false;
        }
        if (other.targetKeyId() == null ^ this.targetKeyId() == null) {
            return false;
        }
        if (other.targetKeyId() != null && !other.targetKeyId().equals(this.targetKeyId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (aliasName() != null) {
            sb.append("AliasName: ").append(aliasName()).append(",");
        }
        if (aliasArn() != null) {
            sb.append("AliasArn: ").append(aliasArn()).append(",");
        }
        if (targetKeyId() != null) {
            sb.append("TargetKeyId: ").append(targetKeyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AliasListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AliasListEntry> {
        /**
         * <p>
         * String that contains the alias.
         * </p>
         * 
         * @param aliasName
         *        String that contains the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * String that contains the key ARN.
         * </p>
         * 
         * @param aliasArn
         *        String that contains the key ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasArn(String aliasArn);

        /**
         * <p>
         * String that contains the key identifier referred to by the alias.
         * </p>
         * 
         * @param targetKeyId
         *        String that contains the key identifier referred to by the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKeyId(String targetKeyId);
    }

    private static final class BuilderImpl implements Builder {
        private String aliasName;

        private String aliasArn;

        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasListEntry model) {
            setAliasName(model.aliasName);
            setAliasArn(model.aliasArn);
            setTargetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getAliasArn() {
            return aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getTargetKeyId() {
            return targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        @Override
        public AliasListEntry build() {
            return new AliasListEntry(this);
        }
    }
}
