/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyListEntryMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> KEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyArn").isBinary(false).build();
    private static final KeyListEntryMarshaller INSTANCE = new KeyListEntryMarshaller();

    private KeyListEntryMarshaller() {
    }

    public static KeyListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyListEntry keyListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyListEntry, (String)"keyListEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyListEntry.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)keyListEntry.keyArn(), KEYARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

