/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GrantListEntryMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> GRANTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<String> GRANTEEPRINCIPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GranteePrincipal").isBinary(false).build();
    private static final MarshallingInfo<String> RETIRINGPRINCIPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetiringPrincipal").isBinary(false).build();
    private static final MarshallingInfo<String> ISSUINGACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssuingAccount").isBinary(false).build();
    private static final MarshallingInfo<List> OPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operations").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Constraints").isBinary(false).build();
    private static final GrantListEntryMarshaller INSTANCE = new GrantListEntryMarshaller();

    private GrantListEntryMarshaller() {
    }

    public static GrantListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GrantListEntry grantListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)grantListEntry, (String)"grantListEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)grantListEntry.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.grantId(), GRANTID_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.granteePrincipal(), GRANTEEPRINCIPAL_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.retiringPrincipal(), RETIRINGPRINCIPAL_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.issuingAccount(), ISSUINGACCOUNT_BINDING);
            protocolMarshaller.marshall(grantListEntry.operationsAsStrings(), OPERATIONS_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.constraints(), CONSTRAINTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

