/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GenerateDataKeyWithoutPlaintextRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContext").isBinary(false).build();
    private static final MarshallingInfo<String> KEYSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySpec").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfBytes").isBinary(false).build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").isBinary(false).build();
    private static final GenerateDataKeyWithoutPlaintextRequestModelMarshaller INSTANCE = new GenerateDataKeyWithoutPlaintextRequestModelMarshaller();

    private GenerateDataKeyWithoutPlaintextRequestModelMarshaller() {
    }

    public static GenerateDataKeyWithoutPlaintextRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)generateDataKeyWithoutPlaintextRequest), (String)"generateDataKeyWithoutPlaintextRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)generateDataKeyWithoutPlaintextRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall(generateDataKeyWithoutPlaintextRequest.encryptionContext(), ENCRYPTIONCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)generateDataKeyWithoutPlaintextRequest.keySpecAsString(), KEYSPEC_BINDING);
            protocolMarshaller.marshall((Object)generateDataKeyWithoutPlaintextRequest.numberOfBytes(), NUMBEROFBYTES_BINDING);
            protocolMarshaller.marshall(generateDataKeyWithoutPlaintextRequest.grantTokens(), GRANTTOKENS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

