/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.services.kms.model.GrantOperation;
import software.amazon.awssdk.services.kms.model.GrantOperationListCopier;
import software.amazon.awssdk.services.kms.transform.GrantListEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrantListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, GrantListEntry> {
    private final String keyId;
    private final String grantId;
    private final String name;
    private final Instant creationDate;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final String issuingAccount;
    private final List<String> operations;
    private final GrantConstraints constraints;

    private GrantListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
        this.name = builder.name;
        this.creationDate = builder.creationDate;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.issuingAccount = builder.issuingAccount;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
    }

    public String keyId() {
        return this.keyId;
    }

    public String grantId() {
        return this.grantId;
    }

    public String name() {
        return this.name;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String granteePrincipal() {
        return this.granteePrincipal;
    }

    public String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public String issuingAccount() {
        return this.issuingAccount;
    }

    public List<GrantOperation> operations() {
        return TypeConverter.convert(this.operations, GrantOperation::fromValue);
    }

    public List<String> operationsAsStrings() {
        return this.operations;
    }

    public GrantConstraints constraints() {
        return this.constraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.retiringPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuingAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantListEntry)) {
            return false;
        }
        GrantListEntry other = (GrantListEntry)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.grantId(), other.grantId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.granteePrincipal(), other.granteePrincipal()) && Objects.equals(this.retiringPrincipal(), other.retiringPrincipal()) && Objects.equals(this.issuingAccount(), other.issuingAccount()) && Objects.equals(this.operationsAsStrings(), other.operationsAsStrings()) && Objects.equals(this.constraints(), other.constraints());
    }

    public String toString() {
        return ToString.builder((String)"GrantListEntry").add("KeyId", (Object)this.keyId()).add("GrantId", (Object)this.grantId()).add("Name", (Object)this.name()).add("CreationDate", (Object)this.creationDate()).add("GranteePrincipal", (Object)this.granteePrincipal()).add("RetiringPrincipal", (Object)this.retiringPrincipal()).add("IssuingAccount", (Object)this.issuingAccount()).add("Operations", this.operationsAsStrings()).add("Constraints", (Object)this.constraints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.ofNullable(clazz.cast(this.grantId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "GranteePrincipal": {
                return Optional.ofNullable(clazz.cast(this.granteePrincipal()));
            }
            case "RetiringPrincipal": {
                return Optional.ofNullable(clazz.cast(this.retiringPrincipal()));
            }
            case "IssuingAccount": {
                return Optional.ofNullable(clazz.cast(this.issuingAccount()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operationsAsStrings()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String grantId;
        private String name;
        private Instant creationDate;
        private String granteePrincipal;
        private String retiringPrincipal;
        private String issuingAccount;
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private GrantConstraints constraints;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantListEntry model) {
            this.keyId(model.keyId);
            this.grantId(model.grantId);
            this.name(model.name);
            this.creationDate(model.creationDate);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.issuingAccount(model.issuingAccount);
            this.operationsWithStrings(model.operations);
            this.constraints(model.constraints);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        public final String getIssuingAccount() {
            return this.issuingAccount;
        }

        @Override
        public final Builder issuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
            return this;
        }

        public final void setIssuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
        }

        public final Collection<String> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String ... operations) {
            this.operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<GrantOperation> operations) {
            this.operations = GrantOperationListCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(GrantOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        public final GrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(GrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        public GrantListEntry build() {
            return new GrantListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GrantListEntry> {
        public Builder keyId(String var1);

        public Builder grantId(String var1);

        public Builder name(String var1);

        public Builder creationDate(Instant var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder issuingAccount(String var1);

        public Builder operationsWithStrings(Collection<String> var1);

        public Builder operationsWithStrings(String ... var1);

        public Builder operations(Collection<GrantOperation> var1);

        public Builder operations(GrantOperation ... var1);

        public Builder constraints(GrantConstraints var1);

        default public Builder constraints(Consumer<GrantConstraints.Builder> constraints) {
            return this.constraints((GrantConstraints)((GrantConstraints.Builder)GrantConstraints.builder().applyMutation(constraints)).build());
        }
    }
}

