/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateDataKeyResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GenerateDataKeyResponse> {
    private final SdkBytes ciphertextBlob;
    private final SdkBytes plaintext;
    private final String keyId;

    private GenerateDataKeyResponse(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.plaintext = builder.plaintext;
        this.keyId = builder.keyId;
    }

    public SdkBytes ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public SdkBytes plaintext() {
        return this.plaintext;
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyResponse)) {
            return false;
        }
        GenerateDataKeyResponse other = (GenerateDataKeyResponse)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.plaintext(), other.plaintext()) && Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        return ToString.builder((String)"GenerateDataKeyResponse").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("Plaintext", (Object)this.plaintext()).add("KeyId", (Object)this.keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.ciphertextBlob()));
            }
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes ciphertextBlob;
        private SdkBytes plaintext;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyResponse model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.plaintext(model.plaintext);
            this.keyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob == null ? null : this.ciphertextBlob.asByteBuffer();
        }

        @Override
        public final Builder ciphertextBlob(SdkBytes ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((SdkBytes)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob(ciphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextBlob));
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = StandardMemberCopier.copy((SdkBytes)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public GenerateDataKeyResponse build() {
            return new GenerateDataKeyResponse(this);
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    CopyableBuilder<Builder, GenerateDataKeyResponse> {
        public Builder ciphertextBlob(SdkBytes var1);

        public Builder plaintext(SdkBytes var1);

        public Builder keyId(String var1);
    }
}

