/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAliasRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, DeleteAliasRequest> {
    private final String aliasName;

    private DeleteAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasName = builder.aliasName;
    }

    public String aliasName() {
        return this.aliasName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAliasRequest)) {
            return false;
        }
        DeleteAliasRequest other = (DeleteAliasRequest)((Object)obj);
        return Objects.equals(this.aliasName(), other.aliasName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAliasRequest").add("AliasName", (Object)this.aliasName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String aliasName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAliasRequest model) {
            super(model);
            this.aliasName(model.aliasName);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAliasRequest build() {
            return new DeleteAliasRequest(this);
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    CopyableBuilder<Builder, DeleteAliasRequest> {
        public Builder aliasName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

