/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnableKeyRotationRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final EnableKeyRotationRequestModelMarshaller INSTANCE = new EnableKeyRotationRequestModelMarshaller();

    private EnableKeyRotationRequestModelMarshaller() {
    }

    public static EnableKeyRotationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnableKeyRotationRequest enableKeyRotationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)enableKeyRotationRequest), (String)"enableKeyRotationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)enableKeyRotationRequest.keyId(), KEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

