/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;

public class ListKeyPoliciesIterable
implements SdkIterable<ListKeyPoliciesResponse> {
    private final KMSClient client;
    private final ListKeyPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeyPoliciesIterable(KMSClient client, ListKeyPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeyPoliciesResponseFetcher();
    }

    public Iterator<ListKeyPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> policyNames() {
        Function<ListKeyPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListKeyPoliciesIterable resume(ListKeyPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListKeyPoliciesIterable(this.client, (ListKeyPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListKeyPoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListKeyPoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListKeyPoliciesResponseFetcher
    implements SyncPageFetcher<ListKeyPoliciesResponse> {
        private ListKeyPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyPoliciesResponse previousPage) {
            return previousPage.truncated();
        }

        public ListKeyPoliciesResponse nextPage(ListKeyPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListKeyPoliciesIterable.this.client.listKeyPolicies(ListKeyPoliciesIterable.this.firstRequest);
            }
            return ListKeyPoliciesIterable.this.client.listKeyPolicies((ListKeyPoliciesRequest)((Object)ListKeyPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

