/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;

public class ListGrantsIterable
implements SdkIterable<ListGrantsResponse> {
    private final KMSClient client;
    private final ListGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGrantsIterable(KMSClient client, ListGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGrantsResponseFetcher();
    }

    public Iterator<ListGrantsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<GrantListEntry> grants() {
        Function<ListGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListGrantsIterable resume(ListGrantsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGrantsIterable(this.client, (ListGrantsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListGrantsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListGrantsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListGrantsResponseFetcher
    implements SyncPageFetcher<ListGrantsResponse> {
        private ListGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListGrantsResponse previousPage) {
            return previousPage.truncated();
        }

        public ListGrantsResponse nextPage(ListGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListGrantsIterable.this.client.listGrants(ListGrantsIterable.this.firstRequest);
            }
            return ListGrantsIterable.this.client.listGrants((ListGrantsRequest)((Object)ListGrantsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

