/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.KMSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReEncryptResponse
extends KMSResponse
implements ToCopyableBuilder<Builder, ReEncryptResponse> {
    private final ByteBuffer ciphertextBlob;
    private final String sourceKeyId;
    private final String keyId;

    private ReEncryptResponse(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceKeyId = builder.sourceKeyId;
        this.keyId = builder.keyId;
    }

    public ByteBuffer ciphertextBlob() {
        return this.ciphertextBlob == null ? null : this.ciphertextBlob.asReadOnlyBuffer();
    }

    public String sourceKeyId() {
        return this.sourceKeyId;
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptResponse)) {
            return false;
        }
        ReEncryptResponse other = (ReEncryptResponse)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.sourceKeyId(), other.sourceKeyId()) && Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        return ToString.builder((String)"ReEncryptResponse").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("SourceKeyId", (Object)this.sourceKeyId()).add("KeyId", (Object)this.keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.of(clazz.cast(this.ciphertextBlob()));
            }
            case "SourceKeyId": {
                return Optional.of(clazz.cast(this.sourceKeyId()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSResponse.BuilderImpl
    implements Builder {
        private ByteBuffer ciphertextBlob;
        private String sourceKeyId;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptResponse model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.sourceKeyId(model.sourceKeyId);
            this.keyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
        }

        public final String getSourceKeyId() {
            return this.sourceKeyId;
        }

        @Override
        public final Builder sourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
            return this;
        }

        public final void setSourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public ReEncryptResponse build() {
            return new ReEncryptResponse(this);
        }
    }

    public static interface Builder
    extends KMSResponse.Builder,
    CopyableBuilder<Builder, ReEncryptResponse> {
        public Builder ciphertextBlob(ByteBuffer var1);

        public Builder sourceKeyId(String var1);

        public Builder keyId(String var1);
    }
}

