/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideomedia;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisvideomedia.DefaultKinesisVideoMediaAsyncClient;
import software.amazon.awssdk.services.kinesisvideomedia.DefaultKinesisVideoMediaBaseClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaAsyncClient;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaAsyncClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideomedia.endpoints.KinesisVideoMediaEndpointProvider;

@SdkInternalApi
final class DefaultKinesisVideoMediaAsyncClientBuilder
extends DefaultKinesisVideoMediaBaseClientBuilder<KinesisVideoMediaAsyncClientBuilder, KinesisVideoMediaAsyncClient>
implements KinesisVideoMediaAsyncClientBuilder {
    DefaultKinesisVideoMediaAsyncClientBuilder() {
    }

    @Override
    public DefaultKinesisVideoMediaAsyncClientBuilder endpointProvider(KinesisVideoMediaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisVideoMediaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKinesisVideoMediaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KinesisVideoMediaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisVideoMediaAsyncClient client = new DefaultKinesisVideoMediaAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisVideoMediaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisVideoMediaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

