/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamInfo> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::deviceName)).setter(StreamInfo.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::streamName)).setter(StreamInfo.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::streamARN)).setter(StreamInfo.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::mediaType)).setter(StreamInfo.setter(Builder::mediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::kmsKeyId)).setter(StreamInfo.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::version)).setter(StreamInfo.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamInfo.getter(StreamInfo::statusAsString)).setter(StreamInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StreamInfo.getter(StreamInfo::creationTime)).setter(StreamInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StreamInfo.getter(StreamInfo::dataRetentionInHours)).setter(StreamInfo.setter(Builder::dataRetentionInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, STREAM_NAME_FIELD, STREAM_ARN_FIELD, MEDIA_TYPE_FIELD, KMS_KEY_ID_FIELD, VERSION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, DATA_RETENTION_IN_HOURS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final String streamName;
    private final String streamARN;
    private final String mediaType;
    private final String kmsKeyId;
    private final String version;
    private final String status;
    private final Instant creationTime;
    private final Integer dataRetentionInHours;

    private StreamInfo(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.mediaType = builder.mediaType;
        this.kmsKeyId = builder.kmsKeyId;
        this.version = builder.version;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.dataRetentionInHours = builder.dataRetentionInHours;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String version() {
        return this.version;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Integer dataRetentionInHours() {
        return this.dataRetentionInHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionInHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInfo)) {
            return false;
        }
        StreamInfo other = (StreamInfo)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.mediaType(), other.mediaType()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.dataRetentionInHours(), other.dataRetentionInHours());
    }

    public String toString() {
        return ToString.builder((String)"StreamInfo").add("DeviceName", (Object)this.deviceName()).add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("MediaType", (Object)this.mediaType()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("DataRetentionInHours", (Object)this.dataRetentionInHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "MediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DataRetentionInHours": {
                return Optional.ofNullable(clazz.cast(this.dataRetentionInHours()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamInfo, T> g) {
        return obj -> g.apply((StreamInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String streamName;
        private String streamARN;
        private String mediaType;
        private String kmsKeyId;
        private String version;
        private String status;
        private Instant creationTime;
        private Integer dataRetentionInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamInfo model) {
            this.deviceName(model.deviceName);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.mediaType(model.mediaType);
            this.kmsKeyId(model.kmsKeyId);
            this.version(model.version);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.dataRetentionInHours(model.dataRetentionInHours);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getDataRetentionInHours() {
            return this.dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        public StreamInfo build() {
            return new StreamInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamInfo> {
        public Builder deviceName(String var1);

        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder mediaType(String var1);

        public Builder kmsKeyId(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder creationTime(Instant var1);

        public Builder dataRetentionInHours(Integer var1);
    }
}

