/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.ImageGenerationConfiguration;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateImageGenerationConfigurationRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UpdateImageGenerationConfigurationRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UpdateImageGenerationConfigurationRequest.getter(UpdateImageGenerationConfigurationRequest::streamName)).setter(UpdateImageGenerationConfigurationRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UpdateImageGenerationConfigurationRequest.getter(UpdateImageGenerationConfigurationRequest::streamARN)).setter(UpdateImageGenerationConfigurationRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<ImageGenerationConfiguration> IMAGE_GENERATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageGenerationConfiguration").getter(UpdateImageGenerationConfigurationRequest.getter(UpdateImageGenerationConfigurationRequest::imageGenerationConfiguration)).setter(UpdateImageGenerationConfigurationRequest.setter(Builder::imageGenerationConfiguration)).constructor(ImageGenerationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageGenerationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, IMAGE_GENERATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateImageGenerationConfigurationRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String streamARN;
    private final ImageGenerationConfiguration imageGenerationConfiguration;

    private UpdateImageGenerationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.imageGenerationConfiguration = builder.imageGenerationConfiguration;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final ImageGenerationConfiguration imageGenerationConfiguration() {
        return this.imageGenerationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageGenerationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageGenerationConfigurationRequest)) {
            return false;
        }
        UpdateImageGenerationConfigurationRequest other = (UpdateImageGenerationConfigurationRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.imageGenerationConfiguration(), other.imageGenerationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateImageGenerationConfigurationRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("ImageGenerationConfiguration", (Object)this.imageGenerationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "ImageGenerationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageGenerationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("ImageGenerationConfiguration", IMAGE_GENERATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageGenerationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateImageGenerationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private ImageGenerationConfiguration imageGenerationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageGenerationConfigurationRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.imageGenerationConfiguration(model.imageGenerationConfiguration);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final ImageGenerationConfiguration.Builder getImageGenerationConfiguration() {
            return this.imageGenerationConfiguration != null ? this.imageGenerationConfiguration.toBuilder() : null;
        }

        public final void setImageGenerationConfiguration(ImageGenerationConfiguration.BuilderImpl imageGenerationConfiguration) {
            this.imageGenerationConfiguration = imageGenerationConfiguration != null ? imageGenerationConfiguration.build() : null;
        }

        @Override
        public final Builder imageGenerationConfiguration(ImageGenerationConfiguration imageGenerationConfiguration) {
            this.imageGenerationConfiguration = imageGenerationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageGenerationConfigurationRequest build() {
            return new UpdateImageGenerationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateImageGenerationConfigurationRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder imageGenerationConfiguration(ImageGenerationConfiguration var1);

        default public Builder imageGenerationConfiguration(Consumer<ImageGenerationConfiguration.Builder> imageGenerationConfiguration) {
            return this.imageGenerationConfiguration((ImageGenerationConfiguration)((ImageGenerationConfiguration.Builder)ImageGenerationConfiguration.builder().applyMutation(imageGenerationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

