/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelInfoListCopier;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSignalingChannelsResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, ListSignalingChannelsResponse> {
    private static final SdkField<List<ChannelInfo>> CHANNEL_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelInfoList").getter(ListSignalingChannelsResponse.getter(ListSignalingChannelsResponse::channelInfoList)).setter(ListSignalingChannelsResponse.setter(Builder::channelInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSignalingChannelsResponse.getter(ListSignalingChannelsResponse::nextToken)).setter(ListSignalingChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSignalingChannelsResponse.memberNameToFieldInitializer();
    private final List<ChannelInfo> channelInfoList;
    private final String nextToken;

    private ListSignalingChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channelInfoList = builder.channelInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChannelInfoList() {
        return this.channelInfoList != null && !(this.channelInfoList instanceof SdkAutoConstructList);
    }

    public final List<ChannelInfo> channelInfoList() {
        return this.channelInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelInfoList() ? this.channelInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSignalingChannelsResponse)) {
            return false;
        }
        ListSignalingChannelsResponse other = (ListSignalingChannelsResponse)((Object)obj);
        return this.hasChannelInfoList() == other.hasChannelInfoList() && Objects.equals(this.channelInfoList(), other.channelInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSignalingChannelsResponse").add("ChannelInfoList", this.hasChannelInfoList() ? this.channelInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelInfoList": {
                return Optional.ofNullable(clazz.cast(this.channelInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelInfoList", CHANNEL_INFO_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSignalingChannelsResponse, T> g) {
        return obj -> g.apply((ListSignalingChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private List<ChannelInfo> channelInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSignalingChannelsResponse model) {
            super(model);
            this.channelInfoList(model.channelInfoList);
            this.nextToken(model.nextToken);
        }

        public final List<ChannelInfo.Builder> getChannelInfoList() {
            List<ChannelInfo.Builder> result = ChannelInfoListCopier.copyToBuilder(this.channelInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelInfoList(Collection<ChannelInfo.BuilderImpl> channelInfoList) {
            this.channelInfoList = ChannelInfoListCopier.copyFromBuilder(channelInfoList);
        }

        @Override
        public final Builder channelInfoList(Collection<ChannelInfo> channelInfoList) {
            this.channelInfoList = ChannelInfoListCopier.copy(channelInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelInfoList(ChannelInfo ... channelInfoList) {
            this.channelInfoList(Arrays.asList(channelInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelInfoList(Consumer<ChannelInfo.Builder> ... channelInfoList) {
            this.channelInfoList(Stream.of(channelInfoList).map(c -> (ChannelInfo)((ChannelInfo.Builder)ChannelInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSignalingChannelsResponse build() {
            return new ListSignalingChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSignalingChannelsResponse> {
        public Builder channelInfoList(Collection<ChannelInfo> var1);

        public Builder channelInfoList(ChannelInfo ... var1);

        public Builder channelInfoList(Consumer<ChannelInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

