/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.MediaUriType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaSourceConfig> {
    private static final SdkField<String> MEDIA_URI_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaUriSecretArn").getter(MediaSourceConfig.getter(MediaSourceConfig::mediaUriSecretArn)).setter(MediaSourceConfig.setter(Builder::mediaUriSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUriSecretArn").build()}).build();
    private static final SdkField<String> MEDIA_URI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaUriType").getter(MediaSourceConfig.getter(MediaSourceConfig::mediaUriTypeAsString)).setter(MediaSourceConfig.setter(Builder::mediaUriType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUriType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_URI_SECRET_ARN_FIELD, MEDIA_URI_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaSourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaUriSecretArn;
    private final String mediaUriType;

    private MediaSourceConfig(BuilderImpl builder) {
        this.mediaUriSecretArn = builder.mediaUriSecretArn;
        this.mediaUriType = builder.mediaUriType;
    }

    public final String mediaUriSecretArn() {
        return this.mediaUriSecretArn;
    }

    public final MediaUriType mediaUriType() {
        return MediaUriType.fromValue(this.mediaUriType);
    }

    public final String mediaUriTypeAsString() {
        return this.mediaUriType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUriSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUriTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaSourceConfig)) {
            return false;
        }
        MediaSourceConfig other = (MediaSourceConfig)obj;
        return Objects.equals(this.mediaUriSecretArn(), other.mediaUriSecretArn()) && Objects.equals(this.mediaUriTypeAsString(), other.mediaUriTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MediaSourceConfig").add("MediaUriSecretArn", (Object)(this.mediaUriSecretArn() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaUriType", (Object)this.mediaUriTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaUriSecretArn": {
                return Optional.ofNullable(clazz.cast(this.mediaUriSecretArn()));
            }
            case "MediaUriType": {
                return Optional.ofNullable(clazz.cast(this.mediaUriTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MediaUriSecretArn", MEDIA_URI_SECRET_ARN_FIELD);
        map.put("MediaUriType", MEDIA_URI_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaSourceConfig, T> g) {
        return obj -> g.apply((MediaSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaUriSecretArn;
        private String mediaUriType;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaSourceConfig model) {
            this.mediaUriSecretArn(model.mediaUriSecretArn);
            this.mediaUriType(model.mediaUriType);
        }

        public final String getMediaUriSecretArn() {
            return this.mediaUriSecretArn;
        }

        public final void setMediaUriSecretArn(String mediaUriSecretArn) {
            this.mediaUriSecretArn = mediaUriSecretArn;
        }

        @Override
        public final Builder mediaUriSecretArn(String mediaUriSecretArn) {
            this.mediaUriSecretArn = mediaUriSecretArn;
            return this;
        }

        public final String getMediaUriType() {
            return this.mediaUriType;
        }

        public final void setMediaUriType(String mediaUriType) {
            this.mediaUriType = mediaUriType;
        }

        @Override
        public final Builder mediaUriType(String mediaUriType) {
            this.mediaUriType = mediaUriType;
            return this;
        }

        @Override
        public final Builder mediaUriType(MediaUriType mediaUriType) {
            this.mediaUriType(mediaUriType == null ? null : mediaUriType.toString());
            return this;
        }

        public MediaSourceConfig build() {
            return new MediaSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaSourceConfig> {
        public Builder mediaUriSecretArn(String var1);

        public Builder mediaUriType(String var1);

        public Builder mediaUriType(MediaUriType var1);
    }
}

