/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisvideo.DefaultKinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.DefaultKinesisVideoBaseClientBuilder;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClientBuilder;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideo.endpoints.KinesisVideoEndpointProvider;

@SdkInternalApi
final class DefaultKinesisVideoAsyncClientBuilder
extends DefaultKinesisVideoBaseClientBuilder<KinesisVideoAsyncClientBuilder, KinesisVideoAsyncClient>
implements KinesisVideoAsyncClientBuilder {
    DefaultKinesisVideoAsyncClientBuilder() {
    }

    @Override
    public DefaultKinesisVideoAsyncClientBuilder endpointProvider(KinesisVideoEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisVideoAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKinesisVideoAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KinesisVideoServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisVideoAsyncClient client = new DefaultKinesisVideoAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisVideoServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisVideoServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

