/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsResponse;

public class ListEdgeAgentConfigurationsPublisher
implements SdkPublisher<ListEdgeAgentConfigurationsResponse> {
    private final KinesisVideoAsyncClient client;
    private final ListEdgeAgentConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEdgeAgentConfigurationsPublisher(KinesisVideoAsyncClient client, ListEdgeAgentConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEdgeAgentConfigurationsPublisher(KinesisVideoAsyncClient client, ListEdgeAgentConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEdgeAgentConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEdgeAgentConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs() {
        Function<ListEdgeAgentConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.edgeConfigs() != null) {
                return response.edgeConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEdgeAgentConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEdgeAgentConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListEdgeAgentConfigurationsResponse> {
        private ListEdgeAgentConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEdgeAgentConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEdgeAgentConfigurationsResponse> nextPage(ListEdgeAgentConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEdgeAgentConfigurationsPublisher.this.client.listEdgeAgentConfigurations(ListEdgeAgentConfigurationsPublisher.this.firstRequest);
            }
            return ListEdgeAgentConfigurationsPublisher.this.client.listEdgeAgentConfigurations((ListEdgeAgentConfigurationsRequest)((Object)ListEdgeAgentConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

