/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoClient;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsResponse;

public class ListEdgeAgentConfigurationsIterable
implements SdkIterable<ListEdgeAgentConfigurationsResponse> {
    private final KinesisVideoClient client;
    private final ListEdgeAgentConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEdgeAgentConfigurationsIterable(KinesisVideoClient client, ListEdgeAgentConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEdgeAgentConfigurationsResponseFetcher();
    }

    public Iterator<ListEdgeAgentConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs() {
        Function<ListEdgeAgentConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.edgeConfigs() != null) {
                return response.edgeConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEdgeAgentConfigurationsResponseFetcher
    implements SyncPageFetcher<ListEdgeAgentConfigurationsResponse> {
        private ListEdgeAgentConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEdgeAgentConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEdgeAgentConfigurationsResponse nextPage(ListEdgeAgentConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEdgeAgentConfigurationsIterable.this.client.listEdgeAgentConfigurations(ListEdgeAgentConfigurationsIterable.this.firstRequest);
            }
            return ListEdgeAgentConfigurationsIterable.this.client.listEdgeAgentConfigurations((ListEdgeAgentConfigurationsRequest)((Object)ListEdgeAgentConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

