/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaUriType {
    RTSP_URI("RTSP_URI"),
    FILE_URI("FILE_URI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaUriType> VALUE_MAP;
    private final String value;

    private MediaUriType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaUriType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaUriType> knownValues() {
        EnumSet<MediaUriType> knownValues = EnumSet.allOf(MediaUriType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaUriType.class, MediaUriType::toString);
    }
}

