/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kinesisvideo.model.ConfigurationStatus;
import software.amazon.awssdk.services.kinesisvideo.model.Format;
import software.amazon.awssdk.services.kinesisvideo.model.FormatConfigCopier;
import software.amazon.awssdk.services.kinesisvideo.model.FormatConfigKey;
import software.amazon.awssdk.services.kinesisvideo.model.ImageGenerationDestinationConfig;
import software.amazon.awssdk.services.kinesisvideo.model.ImageSelectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageGenerationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageGenerationConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::statusAsString)).setter(ImageGenerationConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> IMAGE_SELECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageSelectorType").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::imageSelectorTypeAsString)).setter(ImageGenerationConfiguration.setter(Builder::imageSelectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSelectorType").build()}).build();
    private static final SdkField<ImageGenerationDestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfig").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::destinationConfig)).setter(ImageGenerationConfiguration.setter(Builder::destinationConfig)).constructor(ImageGenerationDestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()}).build();
    private static final SdkField<Integer> SAMPLING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SamplingInterval").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::samplingInterval)).setter(ImageGenerationConfiguration.setter(Builder::samplingInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingInterval").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::formatAsString)).setter(ImageGenerationConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FormatConfig").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::formatConfigAsStrings)).setter(ImageGenerationConfiguration.setter(Builder::formatConfigWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> WIDTH_PIXELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WidthPixels").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::widthPixels)).setter(ImageGenerationConfiguration.setter(Builder::widthPixels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WidthPixels").build()}).build();
    private static final SdkField<Integer> HEIGHT_PIXELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HeightPixels").getter(ImageGenerationConfiguration.getter(ImageGenerationConfiguration::heightPixels)).setter(ImageGenerationConfiguration.setter(Builder::heightPixels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeightPixels").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, IMAGE_SELECTOR_TYPE_FIELD, DESTINATION_CONFIG_FIELD, SAMPLING_INTERVAL_FIELD, FORMAT_FIELD, FORMAT_CONFIG_FIELD, WIDTH_PIXELS_FIELD, HEIGHT_PIXELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String imageSelectorType;
    private final ImageGenerationDestinationConfig destinationConfig;
    private final Integer samplingInterval;
    private final String format;
    private final Map<String, String> formatConfig;
    private final Integer widthPixels;
    private final Integer heightPixels;

    private ImageGenerationConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.imageSelectorType = builder.imageSelectorType;
        this.destinationConfig = builder.destinationConfig;
        this.samplingInterval = builder.samplingInterval;
        this.format = builder.format;
        this.formatConfig = builder.formatConfig;
        this.widthPixels = builder.widthPixels;
        this.heightPixels = builder.heightPixels;
    }

    public final ConfigurationStatus status() {
        return ConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ImageSelectorType imageSelectorType() {
        return ImageSelectorType.fromValue(this.imageSelectorType);
    }

    public final String imageSelectorTypeAsString() {
        return this.imageSelectorType;
    }

    public final ImageGenerationDestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public final Integer samplingInterval() {
        return this.samplingInterval;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Map<FormatConfigKey, String> formatConfig() {
        return FormatConfigCopier.copyStringToEnum(this.formatConfig);
    }

    public final boolean hasFormatConfig() {
        return this.formatConfig != null && !(this.formatConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatConfigAsStrings() {
        return this.formatConfig;
    }

    public final Integer widthPixels() {
        return this.widthPixels;
    }

    public final Integer heightPixels() {
        return this.heightPixels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatConfig() ? this.formatConfigAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.widthPixels());
        hashCode = 31 * hashCode + Objects.hashCode(this.heightPixels());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageGenerationConfiguration)) {
            return false;
        }
        ImageGenerationConfiguration other = (ImageGenerationConfiguration)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.imageSelectorTypeAsString(), other.imageSelectorTypeAsString()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && Objects.equals(this.samplingInterval(), other.samplingInterval()) && Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasFormatConfig() == other.hasFormatConfig() && Objects.equals(this.formatConfigAsStrings(), other.formatConfigAsStrings()) && Objects.equals(this.widthPixels(), other.widthPixels()) && Objects.equals(this.heightPixels(), other.heightPixels());
    }

    public final String toString() {
        return ToString.builder((String)"ImageGenerationConfiguration").add("Status", (Object)this.statusAsString()).add("ImageSelectorType", (Object)this.imageSelectorTypeAsString()).add("DestinationConfig", (Object)this.destinationConfig()).add("SamplingInterval", (Object)this.samplingInterval()).add("Format", (Object)this.formatAsString()).add("FormatConfig", this.hasFormatConfig() ? this.formatConfigAsStrings() : null).add("WidthPixels", (Object)this.widthPixels()).add("HeightPixels", (Object)this.heightPixels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ImageSelectorType": {
                return Optional.ofNullable(clazz.cast(this.imageSelectorTypeAsString()));
            }
            case "DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "SamplingInterval": {
                return Optional.ofNullable(clazz.cast(this.samplingInterval()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "FormatConfig": {
                return Optional.ofNullable(clazz.cast(this.formatConfigAsStrings()));
            }
            case "WidthPixels": {
                return Optional.ofNullable(clazz.cast(this.widthPixels()));
            }
            case "HeightPixels": {
                return Optional.ofNullable(clazz.cast(this.heightPixels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageGenerationConfiguration, T> g) {
        return obj -> g.apply((ImageGenerationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String imageSelectorType;
        private ImageGenerationDestinationConfig destinationConfig;
        private Integer samplingInterval;
        private String format;
        private Map<String, String> formatConfig = DefaultSdkAutoConstructMap.getInstance();
        private Integer widthPixels;
        private Integer heightPixels;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageGenerationConfiguration model) {
            this.status(model.status);
            this.imageSelectorType(model.imageSelectorType);
            this.destinationConfig(model.destinationConfig);
            this.samplingInterval(model.samplingInterval);
            this.format(model.format);
            this.formatConfigWithStrings(model.formatConfig);
            this.widthPixels(model.widthPixels);
            this.heightPixels(model.heightPixels);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getImageSelectorType() {
            return this.imageSelectorType;
        }

        public final void setImageSelectorType(String imageSelectorType) {
            this.imageSelectorType = imageSelectorType;
        }

        @Override
        public final Builder imageSelectorType(String imageSelectorType) {
            this.imageSelectorType = imageSelectorType;
            return this;
        }

        @Override
        public final Builder imageSelectorType(ImageSelectorType imageSelectorType) {
            this.imageSelectorType(imageSelectorType == null ? null : imageSelectorType.toString());
            return this;
        }

        public final ImageGenerationDestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(ImageGenerationDestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(ImageGenerationDestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Integer getSamplingInterval() {
            return this.samplingInterval;
        }

        public final void setSamplingInterval(Integer samplingInterval) {
            this.samplingInterval = samplingInterval;
        }

        @Override
        public final Builder samplingInterval(Integer samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Map<String, String> getFormatConfig() {
            if (this.formatConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatConfig;
        }

        public final void setFormatConfig(Map<String, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copy(formatConfig);
        }

        @Override
        public final Builder formatConfigWithStrings(Map<String, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copy(formatConfig);
            return this;
        }

        @Override
        public final Builder formatConfig(Map<FormatConfigKey, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copyEnumToString(formatConfig);
            return this;
        }

        public final Integer getWidthPixels() {
            return this.widthPixels;
        }

        public final void setWidthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
        }

        @Override
        public final Builder widthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
            return this;
        }

        public final Integer getHeightPixels() {
            return this.heightPixels;
        }

        public final void setHeightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
        }

        @Override
        public final Builder heightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
            return this;
        }

        public ImageGenerationConfiguration build() {
            return new ImageGenerationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageGenerationConfiguration> {
        public Builder status(String var1);

        public Builder status(ConfigurationStatus var1);

        public Builder imageSelectorType(String var1);

        public Builder imageSelectorType(ImageSelectorType var1);

        public Builder destinationConfig(ImageGenerationDestinationConfig var1);

        default public Builder destinationConfig(Consumer<ImageGenerationDestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((ImageGenerationDestinationConfig)((ImageGenerationDestinationConfig.Builder)ImageGenerationDestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder samplingInterval(Integer var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder formatConfigWithStrings(Map<String, String> var1);

        public Builder formatConfig(Map<FormatConfigKey, String> var1);

        public Builder widthPixels(Integer var1);

        public Builder heightPixels(Integer var1);
    }
}

