/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMappedResourceConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMappedResourceConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem;

public class DescribeMappedResourceConfigurationPublisher
implements SdkPublisher<DescribeMappedResourceConfigurationResponse> {
    private final KinesisVideoAsyncClient client;
    private final DescribeMappedResourceConfigurationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMappedResourceConfigurationPublisher(KinesisVideoAsyncClient client, DescribeMappedResourceConfigurationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMappedResourceConfigurationPublisher(KinesisVideoAsyncClient client, DescribeMappedResourceConfigurationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMappedResourceConfigurationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMappedResourceConfigurationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MappedResourceConfigurationListItem> mappedResourceConfigurationList() {
        Function<DescribeMappedResourceConfigurationResponse, Iterator> getIterator = response -> {
            if (response != null && response.mappedResourceConfigurationList() != null) {
                return response.mappedResourceConfigurationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMappedResourceConfigurationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMappedResourceConfigurationResponseFetcher
    implements AsyncPageFetcher<DescribeMappedResourceConfigurationResponse> {
        private DescribeMappedResourceConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMappedResourceConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMappedResourceConfigurationResponse> nextPage(DescribeMappedResourceConfigurationResponse previousPage) {
            if (previousPage == null) {
                return DescribeMappedResourceConfigurationPublisher.this.client.describeMappedResourceConfiguration(DescribeMappedResourceConfigurationPublisher.this.firstRequest);
            }
            return DescribeMappedResourceConfigurationPublisher.this.client.describeMappedResourceConfiguration((DescribeMappedResourceConfigurationRequest)((Object)DescribeMappedResourceConfigurationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

